/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.sound.midi.MetaEventListener;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Track;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.SoftBevelBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class Groove
extends JPanel
implements ActionListener,
ControlContext,
MetaEventListener {
    final int PROGRAM = 192;
    final int NOTEON = 144;
    final int NOTEOFF = 128;
    int velocity = 100;
    TempoDial tempoDial = new TempoDial();
    Sequencer sequencer;
    Track track;
    TableModel dataModel;
    JTable table;
    int row;
    int col;
    JButton loopB;
    JButton startB;
    JComboBox combo;
    String[] instruments = new String[]{"Acoustic bass drum", "Bass drum 1", "Side stick", "Acoustic snare", "Hand clap", "Electric snare", "Low floor tom", "Closed hi-hat", "High floor tom", "Pedal hi-hat", "Low tom", "Open hi-hat", "Low-mid tom", "Hi-mid tom", "Crash cymbal 1", "High tom", "Ride cymbal 1", "Chinese cymbal", "Ride bell", "Tambourine", "Splash cymbal", "Cowbell", "Crash cymbal 2", "Vibraslap", "Ride cymbal 2", "Hi bongo", "Low bongo", "Mute hi conga", "Open hi conga", "Low conga", "High timbale", "Low timbale", "High agogo", "Low agogo", "Cabasa", "Maracas", "Short whistle", "Long whistle", "Short guiro", "Long guiro", "Claves", "Hi wood block", "Low wood block", "Mute cuica", "Open cuica", "Mute triangle", "Open triangle"};
    Vector data = new Vector(this.instruments.length);

    public Groove() {
        Object object;
        this.setLayout(new BorderLayout(5, 0));
        EmptyBorder emptyBorder = new EmptyBorder(5, 5, 5, 5);
        this.setBorder(emptyBorder);
        int n = 0;
        int n2 = 35;
        while (n < this.instruments.length) {
            this.data.add(new Data(this.instruments[n], n2));
            ++n;
            ++n2;
        }
        final String[] stringArray = new String[]{"Instrument", "1", "e", "+", "a", "2", "e", "+", "a", "3", "e", "+", "a", "4", "e", "+", "a"};
        this.dataModel = new AbstractTableModel(){

            public int getColumnCount() {
                return stringArray.length;
            }

            public int getRowCount() {
                return Groove.this.data.size();
            }

            public Object getValueAt(int n, int n2) {
                if (n2 == 0) {
                    return ((Data)Groove.this.data.get((int)n)).name;
                }
                return ((Data)Groove.this.data.get((int)n)).staff[n2 - 1];
            }

            public String getColumnName(int n) {
                return stringArray[n];
            }

            public Class getColumnClass(int n) {
                return this.getValueAt(0, n).getClass();
            }

            public boolean isCellEditable(int n, int n2) {
                return n2 != 0;
            }

            public void setValueAt(Object object, int n, int n2) {
                if (n2 == 0) {
                    ((Data)Groove.this.data.get((int)n)).name = (String)object;
                } else {
                    ((Data)Groove.this.data.get((int)n)).staff[n2 - 1] = (Color)object;
                }
            }
        };
        DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer(){

            public void setValue(Object object) {
                this.setBackground((Color)object);
            }
        };
        this.table = new JTable(this.dataModel);
        this.table.getColumn(stringArray[0]).setMinWidth(120);
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        int n3 = 1;
        while (n3 < stringArray.length) {
            object = tableColumnModel.getColumn(n3);
            ((TableColumn)object).setCellRenderer(defaultTableCellRenderer);
            ++n3;
        }
        object = this.table.getSelectionModel();
        object.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                if (!listSelectionModel.isSelectionEmpty()) {
                    Groove.this.row = listSelectionModel.getMinSelectionIndex();
                }
            }
        });
        object = this.table.getColumnModel().getSelectionModel();
        object.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                if (!listSelectionModel.isSelectionEmpty()) {
                    Groove.this.col = listSelectionModel.getMinSelectionIndex();
                }
                if (Groove.this.col != 0) {
                    Color color = ((Data)Groove.this.data.get((int)Groove.this.row)).staff[Groove.this.col - 1];
                    ((Data)Groove.this.data.get((int)Groove.this.row)).staff[Groove.this.col - 1] = color.equals(Color.white) ? Color.black : Color.white;
                    Groove.this.table.tableChanged(new TableModelEvent(Groove.this.dataModel));
                }
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        SoftBevelBorder softBevelBorder = new SoftBevelBorder(0);
        jPanel.setBorder(new CompoundBorder(softBevelBorder, emptyBorder));
        jPanel.add(this.tempoDial);
        jPanel.add(Box.createVerticalStrut(10));
        JPanel jPanel2 = new JPanel(new GridLayout(0, 1, 2, 10));
        this.startB = this.makeButton("Start", this.getBackground());
        jPanel2.add(this.startB);
        this.loopB = this.makeButton("Loop", this.getBackground());
        jPanel2.add(this.loopB);
        jPanel2.add(this.makeButton("Clear Table", this.getBackground()));
        this.combo = new JComboBox();
        this.combo.addActionListener(this);
        this.combo.addItem("Rock Beat 1");
        this.combo.addItem("Rock Beat 2");
        this.combo.addItem("Rock Beat 3");
        jPanel2.add(this.combo);
        jPanel.add(jPanel2);
        jPanel.add(Box.createVerticalStrut(120));
        this.add("West", jPanel);
        this.add("Center", new JScrollPane(this.table));
    }

    public void open() {
        try {
            this.sequencer = MidiSystem.getSequencer();
            this.sequencer.open();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.tempoDial.setSequencer(this.sequencer);
        this.sequencer.addMetaEventListener(this);
    }

    public void close() {
        if (this.startB.getText().startsWith("Stop")) {
            this.startB.doClick(0);
        }
        if (this.sequencer != null) {
            this.sequencer.close();
        }
        this.sequencer = null;
    }

    private JButton makeButton(String string, Color color) {
        JButton jButton = new JButton(string);
        jButton.setBackground(color);
        jButton.addActionListener(this);
        return jButton;
    }

    private void buildTrackThenStartSequencer() {
        Sequence sequence = null;
        try {
            sequence = new Sequence(0.0f, 4);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.track = sequence.createTrack();
        this.createEvent(192, 9, 1, 0L);
        int n = 0;
        while (n < this.data.size()) {
            Data data = (Data)this.data.get(n);
            int n2 = 0;
            while (n2 < data.staff.length) {
                if (data.staff[n2].equals(Color.black)) {
                    this.createEvent(144, 9, data.id, n2);
                    this.createEvent(128, 9, data.id, n2 + 1);
                }
                ++n2;
            }
            ++n;
        }
        this.createEvent(192, 9, 1, 15L);
        try {
            this.sequencer.setSequence(sequence);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.sequencer.start();
        this.sequencer.setTempoInBPM(this.tempoDial.getTempo());
    }

    private void presetTracks(int n) {
        this.clearTable();
        switch (n) {
            case 0: {
                int n2 = 0;
                while (n2 < 16) {
                    this.setCell(42, n2);
                    n2 += 2;
                }
                this.setCell(38, 4);
                this.setCell(38, 12);
                int[] nArray = new int[]{0, 3, 6, 8};
                int n3 = 0;
                while (n3 < nArray.length) {
                    this.setCell(35, nArray[n3]);
                    ++n3;
                }
                break;
            }
            case 1: {
                int n4 = 0;
                while (n4 < 16) {
                    this.setCell(49, n4);
                    n4 += 4;
                }
                int n5 = 0;
                while (n5 < 16) {
                    this.setCell(44, n5);
                    n5 += 2;
                }
                this.setCell(38, 4);
                this.setCell(38, 12);
                int[] nArray = new int[]{0, 2, 3, 7, 9, 10, 15};
                int n6 = 0;
                while (n6 < nArray.length) {
                    this.setCell(35, nArray[n6]);
                    ++n6;
                }
                break;
            }
            case 2: {
                int n7 = 0;
                while (n7 < 16) {
                    this.setCell(53, n7);
                    n7 += 4;
                }
                int n8 = 2;
                while (n8 < 16) {
                    this.setCell(44, n8);
                    n8 += 4;
                }
                this.setCell(39, 4);
                this.setCell(39, 12);
                this.setCell(50, 13);
                this.setCell(45, 14);
                int[] nArray = new int[]{0, 3, 6, 9, 15};
                int n9 = 0;
                while (n9 < nArray.length) {
                    this.setCell(36, nArray[n9]);
                    ++n9;
                }
                break;
            }
        }
        this.table.tableChanged(new TableModelEvent(this.dataModel));
    }

    private void setCell(int n, int n2) {
        int n3 = 0;
        while (n3 < this.data.size()) {
            Data data = (Data)this.data.get(n3);
            if (data.id == n) {
                data.staff[n2] = Color.black;
                break;
            }
            ++n3;
        }
    }

    private void clearTable() {
        int n = 0;
        while (n < this.data.size()) {
            Data data = (Data)this.data.get(n);
            int n2 = 0;
            while (n2 < data.staff.length) {
                data.staff[n2] = Color.white;
                ++n2;
            }
            ++n;
        }
    }

    private void createEvent(int n, int n2, int n3, long l) {
        ShortMessage shortMessage = new ShortMessage();
        try {
            shortMessage.setMessage(n, n2, n3, this.velocity);
            MidiEvent midiEvent = new MidiEvent(shortMessage, l);
            this.track.add(midiEvent);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void meta(MetaMessage metaMessage) {
        if (metaMessage.getType() == 47) {
            if (this.loopB.getBackground().equals(Color.gray)) {
                if (this.sequencer != null && this.sequencer.isOpen()) {
                    this.sequencer.start();
                    this.sequencer.setTempoInBPM(this.tempoDial.getTempo());
                }
            } else {
                this.startB.setText("Start");
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof JComboBox) {
            this.presetTracks(((JComboBox)object).getSelectedIndex());
            if (this.startB.getText().startsWith("Stop")) {
                this.sequencer.stop();
                this.buildTrackThenStartSequencer();
            }
        } else if (object instanceof JButton) {
            JButton jButton = (JButton)object;
            if (jButton.equals(this.startB)) {
                if (jButton.getText().startsWith("Start")) {
                    this.buildTrackThenStartSequencer();
                    jButton.setText("Stop");
                } else {
                    this.sequencer.stop();
                    jButton.setText("Start");
                }
            } else if (jButton.equals(this.loopB)) {
                jButton.setSelected(!jButton.isSelected());
                if (this.loopB.getBackground().equals(Color.gray)) {
                    this.loopB.setBackground(this.getBackground());
                } else {
                    this.loopB.setBackground(Color.gray);
                }
            } else if (jButton.getText().startsWith("Clear")) {
                this.clearTable();
                this.table.tableChanged(new TableModelEvent(this.dataModel));
            }
        }
    }

    public static void main(String[] stringArray) {
        Groove groove = new Groove();
        JFrame jFrame = new JFrame("Rhythm Groove Box");
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        jFrame.getContentPane().add("Center", groove);
        jFrame.pack();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n = 640;
        int n2 = 440;
        ((Component)jFrame).setLocation(dimension.width / 2 - n / 2, dimension.height / 2 - n2 / 2);
        ((Component)jFrame).setSize(n, n2);
        jFrame.show();
        groove.open();
    }

    class Data {
        String name;
        int id;
        Color[] staff = new Color[16];

        public Data(String string, int n) {
            this.name = string;
            this.id = n;
            int n2 = 0;
            while (n2 < this.staff.length) {
                this.staff[n2] = Color.white;
                ++n2;
            }
        }
    }
}

