/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.Vector;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MetaEventListener;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiChannel;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;
import javax.sound.midi.Synthesizer;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.BevelBorder;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class Juke
extends JPanel
implements Runnable,
LineListener,
MetaEventListener,
ControlContext {
    final int bufSize = 16384;
    PlaybackMonitor playbackMonitor = new PlaybackMonitor();
    Vector sounds = new Vector();
    Thread thread;
    Sequencer sequencer;
    boolean midiEOM;
    boolean audioEOM;
    Synthesizer synthesizer;
    MidiChannel[] channels;
    Object currentSound;
    String currentName;
    double duration;
    int num;
    boolean bump;
    boolean paused = false;
    JButton startB;
    JButton pauseB;
    JButton loopB;
    JButton prevB;
    JButton nextB;
    JTable table;
    JSlider panSlider;
    JSlider gainSlider;
    JSlider seekSlider;
    JukeTable jukeTable;
    Loading loading;
    Credits credits;
    String errStr;
    JukeControls controls;
    static /* synthetic */ Class class$javax$sound$sampled$Clip;

    public Juke(String string) {
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(5, 5, 5, 5));
        if (string != null) {
            this.loadJuke(string);
        }
        this.jukeTable = new JukeTable();
        this.controls = new JukeControls();
        JSplitPane jSplitPane = new JSplitPane(1, this.jukeTable, this.controls);
        jSplitPane.setContinuousLayout(true);
        this.add(jSplitPane);
    }

    public void open() {
        try {
            this.sequencer = MidiSystem.getSequencer();
            if (this.sequencer instanceof Synthesizer) {
                this.synthesizer = (Synthesizer)((Object)this.sequencer);
                this.channels = this.synthesizer.getChannels();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
        this.sequencer.addMetaEventListener(this);
        this.credits = new Credits();
        this.credits.start();
    }

    public void close() {
        if (this.credits != null && this.credits.isAlive()) {
            this.credits.interrupt();
        }
        if (this.thread != null && this.startB != null) {
            this.startB.doClick(0);
        }
        if (this.jukeTable != null && this.jukeTable.frame != null) {
            this.jukeTable.frame.dispose();
            this.jukeTable.frame = null;
        }
        if (this.sequencer != null) {
            this.sequencer.close();
        }
    }

    public void loadJuke(String string) {
        try {
            File file = new File(string);
            if (file != null && file.isDirectory()) {
                String[] stringArray = file.list();
                int n = 0;
                while (n < stringArray.length) {
                    File file2 = new File(file.getAbsolutePath(), stringArray[n]);
                    if (file2.isDirectory()) {
                        this.loadJuke(file2.getAbsolutePath());
                    } else {
                        this.addSound(file2);
                    }
                    ++n;
                }
            } else if (file != null && file.exists()) {
                this.addSound(file);
            }
        }
        catch (SecurityException securityException) {
            this.reportStatus(securityException.toString());
            JavaSound.showInfoDialog();
        }
        catch (Exception exception) {
            this.reportStatus(exception.toString());
        }
    }

    private void addSound(File file) {
        String string = file.getName();
        if (string.endsWith(".au") || string.endsWith(".rmf") || string.endsWith(".mid") || string.endsWith(".wav") || string.endsWith(".aif") || string.endsWith(".aiff")) {
            this.sounds.add(file);
        }
    }

    public boolean loadSound(Object object) {
        Object object2;
        this.duration = 0.0;
        this.loading = new Loading();
        this.loading.start();
        if (object instanceof URL) {
            this.currentName = ((URL)object).getFile();
            this.playbackMonitor.repaint();
            try {
                this.currentSound = AudioSystem.getAudioInputStream((URL)object);
            }
            catch (Exception exception) {
                try {
                    this.currentSound = MidiSystem.getSequence((URL)object);
                }
                catch (InvalidMidiDataException invalidMidiDataException) {
                    System.out.println("Unsupported audio file.");
                    return false;
                }
                catch (Exception exception2) {
                    exception2.printStackTrace();
                    this.currentSound = null;
                    return false;
                }
            }
        } else if (object instanceof File) {
            this.currentName = ((File)object).getName();
            this.playbackMonitor.repaint();
            try {
                this.currentSound = AudioSystem.getAudioInputStream((File)object);
            }
            catch (Exception exception) {
                try {
                    object2 = new FileInputStream((File)object);
                    this.currentSound = new BufferedInputStream((InputStream)object2, 1024);
                }
                catch (Exception exception3) {
                    exception3.printStackTrace();
                    this.currentSound = null;
                    return false;
                }
            }
        }
        this.loading.interrupt();
        if (this.sequencer == null) {
            this.currentSound = null;
            return false;
        }
        if (this.currentSound instanceof AudioInputStream) {
            try {
                Object object3;
                AudioInputStream audioInputStream = (AudioInputStream)this.currentSound;
                object2 = audioInputStream.getFormat();
                if (((AudioFormat)object2).getEncoding() == AudioFormat.Encoding.ULAW || ((AudioFormat)object2).getEncoding() == AudioFormat.Encoding.ALAW) {
                    object3 = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, ((AudioFormat)object2).getSampleRate(), ((AudioFormat)object2).getSampleSizeInBits() * 2, ((AudioFormat)object2).getChannels(), ((AudioFormat)object2).getFrameSize() * 2, ((AudioFormat)object2).getFrameRate(), true);
                    audioInputStream = AudioSystem.getAudioInputStream((AudioFormat)object3, audioInputStream);
                    object2 = object3;
                }
                object3 = new DataLine.Info(class$javax$sound$sampled$Clip == null ? (class$javax$sound$sampled$Clip = Juke.class$("javax.sound.sampled.Clip")) : class$javax$sound$sampled$Clip, audioInputStream.getFormat(), (int)audioInputStream.getFrameLength() * ((AudioFormat)object2).getFrameSize());
                Clip clip = (Clip)AudioSystem.getLine((Line.Info)object3);
                clip.addLineListener(this);
                clip.open(audioInputStream);
                this.currentSound = clip;
                this.seekSlider.setMaximum((int)audioInputStream.getFrameLength());
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.currentSound = null;
                return false;
            }
        }
        if (this.currentSound instanceof Sequence || this.currentSound instanceof BufferedInputStream) {
            try {
                this.sequencer.open();
                if (this.currentSound instanceof Sequence) {
                    this.sequencer.setSequence((Sequence)this.currentSound);
                } else {
                    this.sequencer.setSequence((BufferedInputStream)this.currentSound);
                }
                this.seekSlider.setMaximum((int)(this.sequencer.getMicrosecondLength() / 1000L));
            }
            catch (InvalidMidiDataException invalidMidiDataException) {
                System.out.println("Unsupported audio file.");
                this.currentSound = null;
                return false;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.currentSound = null;
                return false;
            }
        }
        this.seekSlider.setValue(0);
        this.seekSlider.setEnabled(true);
        this.panSlider.setEnabled(true);
        this.gainSlider.setEnabled(true);
        this.duration = this.getDuration();
        return true;
    }

    public void playSound() {
        this.playbackMonitor.start();
        this.setGain();
        this.setPan();
        this.bump = false;
        this.audioEOM = false;
        this.midiEOM = false;
        if (this.currentSound instanceof Sequence || this.currentSound instanceof BufferedInputStream && this.thread != null) {
            this.sequencer.start();
            while (!this.midiEOM && this.thread != null && !this.bump) {
                try {
                    Thread.sleep(99L);
                }
                catch (Exception exception) {
                    break;
                }
            }
            this.sequencer.stop();
            this.sequencer.close();
        } else if (this.currentSound instanceof Clip && this.thread != null) {
            Clip clip = (Clip)this.currentSound;
            clip.start();
            try {
                Thread.sleep(99L);
            }
            catch (Exception exception) {}
            while ((this.paused || clip.isActive()) && this.thread != null && !this.bump) {
                try {
                    Thread.sleep(99L);
                }
                catch (Exception exception) {
                    break;
                }
            }
            clip.stop();
            clip.close();
        }
        this.currentSound = null;
        this.playbackMonitor.stop();
    }

    public double getDuration() {
        double d = 0.0;
        if (this.currentSound instanceof Sequence) {
            d = (double)((Sequence)this.currentSound).getMicrosecondLength() / 1000000.0;
        } else if (this.currentSound instanceof BufferedInputStream) {
            d = (double)this.sequencer.getMicrosecondLength() / 1000000.0;
        } else if (this.currentSound instanceof Clip) {
            Clip clip = (Clip)this.currentSound;
            d = (float)clip.getBufferSize() / ((float)clip.getFormat().getFrameSize() * clip.getFormat().getFrameRate());
        }
        return d;
    }

    public double getSeconds() {
        double d = 0.0;
        if (this.currentSound instanceof Clip) {
            Clip clip = (Clip)this.currentSound;
            d = (float)clip.getFramePosition() / clip.getFormat().getFrameRate();
        } else if (this.currentSound instanceof Sequence || this.currentSound instanceof BufferedInputStream) {
            try {
                d = (double)this.sequencer.getMicrosecondPosition() / 1000000.0;
            }
            catch (IllegalStateException illegalStateException) {
                System.out.println("TEMP: IllegalStateException on sequencer.getMicrosecondPosition(): " + illegalStateException);
            }
        }
        return d;
    }

    public void update(LineEvent lineEvent) {
        if (lineEvent.getType() == LineEvent.Type.STOP && !this.paused) {
            this.audioEOM = true;
        }
    }

    public void meta(MetaMessage metaMessage) {
        if (metaMessage.getType() == 47) {
            this.midiEOM = true;
        }
    }

    private void reportStatus(String string) {
        this.errStr = string;
        if (this.errStr != null) {
            System.out.println(this.errStr);
            this.playbackMonitor.repaint();
        }
        if (this.credits != null && this.credits.isAlive()) {
            this.credits.interrupt();
        }
    }

    public Thread getThread() {
        return this.thread;
    }

    public void start() {
        this.thread = new Thread(this);
        this.thread.setName("Juke");
        this.thread.start();
    }

    public void stop() {
        if (this.thread != null) {
            this.thread.interrupt();
        }
        this.thread = null;
    }

    public void run() {
        do {
            this.table.scrollRectToVisible(new Rectangle(0, 0, 1, 1));
            while (this.num < this.sounds.size() && this.thread != null) {
                this.table.scrollRectToVisible(new Rectangle(0, (this.num + 2) * (this.table.getRowHeight() + this.table.getRowMargin()), 1, 1));
                this.table.setRowSelectionInterval(this.num, this.num);
                if (this.loadSound(this.sounds.get(this.num))) {
                    this.playSound();
                }
                try {
                    Thread.sleep(222L);
                }
                catch (Exception exception) {
                    break;
                }
                ++this.num;
            }
            this.num = 0;
        } while (this.loopB.isSelected() && this.thread != null);
        if (this.thread != null) {
            this.startB.doClick();
        }
        this.thread = null;
        this.currentName = null;
        this.currentSound = null;
        this.playbackMonitor.repaint();
    }

    public void setPan() {
        int n = this.panSlider.getValue();
        if (this.currentSound instanceof Clip) {
            try {
                Clip clip = (Clip)this.currentSound;
                FloatControl floatControl = (FloatControl)clip.getControl(FloatControl.Type.PAN);
                floatControl.setValue((float)n / 100.0f);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else if (this.currentSound instanceof Sequence || this.currentSound instanceof BufferedInputStream) {
            int n2 = 0;
            while (n2 < this.channels.length) {
                this.channels[n2].controlChange(10, (int)(((double)n + 100.0) / 200.0 * 127.0));
                ++n2;
            }
        }
    }

    public void setGain() {
        double d = (double)this.gainSlider.getValue() / 100.0;
        if (this.currentSound instanceof Clip) {
            try {
                Clip clip = (Clip)this.currentSound;
                FloatControl floatControl = (FloatControl)clip.getControl(FloatControl.Type.MASTER_GAIN);
                float f = (float)(Math.log(d == 0.0 ? 1.0E-4 : d) / Math.log(10.0) * 20.0);
                floatControl.setValue(f);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else if (this.currentSound instanceof Sequence || this.currentSound instanceof BufferedInputStream) {
            int n = 0;
            while (n < this.channels.length) {
                this.channels[n].controlChange(7, (int)(d * 127.0));
                ++n;
            }
        }
    }

    public static void main(String[] stringArray) {
        File file;
        String string = "./audio";
        final Juke juke = new Juke(stringArray.length == 0 ? string : stringArray[0]);
        juke.open();
        JFrame jFrame = new JFrame("Juke Box");
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }

            public void windowIconified(WindowEvent windowEvent) {
                juke.credits.interrupt();
            }
        });
        jFrame.getContentPane().add("Center", juke);
        jFrame.pack();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n = 750;
        int n2 = 340;
        ((Component)jFrame).setLocation(dimension.width / 2 - n / 2, dimension.height / 2 - n2 / 2);
        ((Component)jFrame).setSize(n, n2);
        ((Component)jFrame).setVisible(true);
        if (stringArray.length > 0 && (file = new File(stringArray[0])) == null && !file.isDirectory()) {
            System.out.println("usage: java Juke audioDirectory");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class Credits
    extends Thread {
        int x;
        Font font16 = new Font("serif", 0, 16);
        String contributors = "Contributors : Kara Kytle, Jan Borgersen, Brian Lichtenwalter";
        int strWidth = ((Component)Juke.this).getFontMetrics(this.font16).stringWidth(this.contributors);

        Credits() {
        }

        public void run() {
            this.x = -999;
            while (!Juke.this.playbackMonitor.isShowing()) {
                try {
                    Thread.sleep(999L);
                }
                catch (Exception exception) {
                    return;
                }
            }
            int n = 0;
            while (n < 100) {
                try {
                    Thread.sleep(99L);
                }
                catch (Exception exception) {
                    return;
                }
                ++n;
            }
            while (true) {
                if (--this.x < -this.strWidth) {
                    this.x = Juke.this.playbackMonitor.getSize().width;
                }
                Juke.this.playbackMonitor.repaint();
                try {
                    Thread.sleep(99L);
                }
                catch (Exception exception) {
                    return;
                }
            }
        }

        public void render(Dimension dimension, Graphics2D graphics2D) {
            if (this.isAlive()) {
                graphics2D.setFont(this.font16);
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                graphics2D.drawString(this.contributors, this.x, dimension.height - 5);
            }
        }
    }

    class Loading
    extends Thread {
        double extent;
        int incr;

        Loading() {
        }

        public void run() {
            this.extent = 360.0;
            this.incr = 10;
            while (true) {
                try {
                    Thread.sleep(99L);
                }
                catch (Exception exception) {
                    break;
                }
                Juke.this.playbackMonitor.repaint();
            }
        }

        public void render(Dimension dimension, Graphics2D graphics2D) {
            if (this.isAlive()) {
                double d;
                FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
                TextLayout textLayout = new TextLayout("Loading", graphics2D.getFont(), fontRenderContext);
                float f = (float)textLayout.getBounds().getWidth();
                textLayout.draw(graphics2D, (float)dimension.width - f - 45.0f, dimension.height - 10);
                double d2 = dimension.width - 33;
                double d3 = dimension.height - 30;
                double d4 = 25.0;
                double d5 = 25.0;
                graphics2D.draw(new Ellipse2D.Double(d2, d3, d4, d5));
                graphics2D.fill(new Arc2D.Double(d2, d3, d4, d5, 90.0, this.extent, 2));
                this.extent -= (double)this.incr;
                if (d < 0.0) {
                    this.extent = 350.0;
                }
            }
        }
    }

    class JukeTable
    extends JPanel
    implements ActionListener {
        TableModel dataModel;
        JFrame frame;
        JTextField textField;
        JButton applyB;

        public JukeTable() {
            JMenuItem jMenuItem;
            this.setLayout(new BorderLayout());
            this.setPreferredSize(new Dimension(260, 300));
            String[] stringArray = new String[]{"#", "Name"};
            this.dataModel = new AbstractTableModel(this, stringArray){
                private final /* synthetic */ String[] val$names;
                private final /* synthetic */ JukeTable this$1;
                {
                    this.this$1 = jukeTable;
                    this.val$names = stringArray;
                }

                public int getColumnCount() {
                    return this.val$names.length;
                }

                public int getRowCount() {
                    return JukeTable.access$000((JukeTable)this.this$1).sounds.size();
                }

                public Object getValueAt(int n, int n2) {
                    if (n2 == 0) {
                        return new Integer(n);
                    }
                    if (n2 == 1) {
                        E e = JukeTable.access$000((JukeTable)this.this$1).sounds.get(n);
                        if (e instanceof File) {
                            return ((File)e).getName();
                        }
                        if (e instanceof URL) {
                            return ((URL)e).getFile();
                        }
                    }
                    return null;
                }

                public String getColumnName(int n) {
                    return this.val$names[n];
                }

                public Class getColumnClass(int n) {
                    return this.getValueAt(0, n).getClass();
                }

                public boolean isCellEditable(int n, int n2) {
                    return false;
                }

                public void setValueAt(Object object, int n, int n2) {
                }
            };
            Juke.this.table = new JTable(this.dataModel);
            TableColumn tableColumn = Juke.this.table.getColumn("#");
            tableColumn.setMaxWidth(20);
            Juke.this.table.sizeColumnsToFit(0);
            JScrollPane jScrollPane = new JScrollPane(Juke.this.table);
            EmptyBorder emptyBorder = new EmptyBorder(5, 5, 2, 5);
            jScrollPane.setBorder(new CompoundBorder(emptyBorder, new EtchedBorder()));
            this.add(jScrollPane);
            JPanel jPanel = new JPanel();
            JMenuBar jMenuBar = new JMenuBar();
            jMenuBar.setBorder(new BevelBorder(0));
            JMenu jMenu = jMenuBar.add(new JMenu("Add"));
            String[] stringArray2 = new String[]{"File or Directory of Files", "URL"};
            int n = 0;
            while (n < stringArray2.length) {
                jMenuItem = jMenu.add(new JMenuItem(stringArray2[n]));
                jMenuItem.addActionListener(this);
                ++n;
            }
            jPanel.add(jMenuBar);
            jMenuBar = new JMenuBar();
            jMenuBar.setBorder(new BevelBorder(0));
            jMenu = jMenuBar.add(new JMenu("Remove"));
            jMenuItem = jMenu.add(new JMenuItem("Selected"));
            jMenuItem.addActionListener(this);
            jMenuItem = jMenu.add(new JMenuItem("All"));
            jMenuItem.addActionListener(this);
            jPanel.add(jMenuBar);
            Juke.this.loopB = this.addButton("loop", jPanel);
            Juke.this.loopB.setBackground(Color.gray);
            Juke.this.loopB.setSelected(true);
            this.add("South", jPanel);
        }

        private JButton addButton(String string, JPanel jPanel) {
            JButton jButton = new JButton(string);
            jButton.addActionListener(this);
            jPanel.add(jButton);
            return jButton;
        }

        private void doFrame(String string) {
            Object object;
            Object object2;
            int n = 500;
            int n2 = 130;
            JPanel jPanel = new JPanel(new BorderLayout());
            JPanel jPanel2 = new JPanel();
            if (string.endsWith("URL")) {
                jPanel2.add(new JLabel("URL :"));
                this.textField = new JTextField("http://foo.bar.com/foo.wav");
                this.textField.addActionListener(this);
            } else {
                jPanel2.add(new JLabel("File or Dir :"));
                object2 = String.valueOf(System.getProperty("file.separator").toCharArray()[0]);
                object = null;
                try {
                    object = System.getProperty("user.dir") + (String)object2;
                }
                catch (SecurityException securityException) {
                    Juke.this.reportStatus(securityException.toString());
                    JavaSound.showInfoDialog();
                    return;
                }
                this.textField = new JTextField((String)object);
                this.textField.setPreferredSize(new Dimension(n - 100, 30));
                this.textField.addActionListener(this);
            }
            jPanel2.add(this.textField);
            jPanel.add(jPanel2);
            object2 = new JPanel();
            this.applyB = this.addButton("Apply", (JPanel)object2);
            this.addButton("Cancel", (JPanel)object2);
            jPanel.add("South", (Component)object2);
            this.frame = new JFrame(string);
            this.frame.getContentPane().add("Center", jPanel);
            this.frame.pack();
            object = Toolkit.getDefaultToolkit().getScreenSize();
            ((Component)this.frame).setLocation(((Dimension)object).width / 2 - n / 2, ((Dimension)object).height / 2 - n2 / 2);
            ((Component)this.frame).setSize(n, n2);
            ((Component)this.frame).setVisible(true);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object instanceof JTextField) {
                this.applyB.doClick();
            } else if (object instanceof JMenuItem) {
                JMenuItem jMenuItem = (JMenuItem)object;
                if (jMenuItem.getText().startsWith("File")) {
                    this.doFrame("Add File or Directory");
                } else if (jMenuItem.getText().equals("URL")) {
                    this.doFrame("Add URL");
                } else if (jMenuItem.getText().equals("Selected")) {
                    int[] nArray = Juke.this.table.getSelectedRows();
                    Vector vector = new Vector();
                    int n = 0;
                    while (n < nArray.length) {
                        vector.add(Juke.this.sounds.get(nArray[n]));
                        ++n;
                    }
                    Juke.this.sounds.removeAll(vector);
                    this.tableChanged();
                } else if (jMenuItem.getText().equals("All")) {
                    Juke.this.sounds.clear();
                    this.tableChanged();
                }
            } else if (object instanceof JButton) {
                JButton jButton = (JButton)actionEvent.getSource();
                if (jButton.getText().equals("Apply")) {
                    String string = this.textField.getText().trim();
                    if (string.startsWith("http") || string.startsWith("file")) {
                        try {
                            Juke.this.sounds.add(new URL(string));
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    } else {
                        Juke.this.loadJuke(string);
                    }
                    this.tableChanged();
                } else if (jButton.getText().equals("Cancel")) {
                    this.frame.dispose();
                    this.frame = null;
                    Juke.this.errStr = null;
                    Juke.this.playbackMonitor.repaint();
                } else if (jButton.getText().equals("loop")) {
                    Juke.this.loopB.setSelected(!Juke.this.loopB.isSelected());
                    Juke.this.loopB.setBackground(Juke.this.loopB.isSelected() ? Color.gray : Color.lightGray);
                }
                Juke.this.startB.setEnabled(Juke.this.sounds.size() != 0);
            }
        }

        public void tableChanged() {
            Juke.this.table.tableChanged(new TableModelEvent(this.dataModel));
        }

        static /* synthetic */ Juke access$000(JukeTable jukeTable) {
            return jukeTable.Juke.this;
        }
    }

    public class PlaybackMonitor
    extends JPanel
    implements Runnable {
        String welcomeStr = "Welcome to Java Sound";
        Thread pbThread;
        Color black = new Color(20, 20, 20);
        Color jfcBlue = new Color(204, 204, 255);
        Color jfcDarkBlue = this.jfcBlue.darker();
        Font font24 = new Font("serif", 1, 24);
        Font font28 = new Font("serif", 1, 28);
        Font font42 = new Font("serif", 1, 42);
        FontMetrics fm28 = ((Component)this).getFontMetrics(this.font28);
        FontMetrics fm42 = ((Component)this).getFontMetrics(this.font42);

        public void paint(Graphics graphics) {
            block9: {
                Dimension dimension;
                Graphics2D graphics2D;
                block10: {
                    block8: {
                        graphics2D = (Graphics2D)graphics;
                        dimension = this.getSize();
                        graphics2D.setBackground(this.black);
                        graphics2D.clearRect(0, 0, dimension.width, dimension.height);
                        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                        graphics2D.setColor(this.jfcBlue);
                        if (Juke.this.errStr == null) break block8;
                        graphics2D.setFont(new Font("serif", 1, 18));
                        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                        graphics2D.drawString("ERROR", 5, 20);
                        AttributedString attributedString = new AttributedString(Juke.this.errStr);
                        Font font = new Font("serif", 0, 12);
                        attributedString.addAttribute(TextAttribute.FONT, font, 0, Juke.this.errStr.length());
                        AttributedCharacterIterator attributedCharacterIterator = attributedString.getIterator();
                        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
                        LineBreakMeasurer lineBreakMeasurer = new LineBreakMeasurer(attributedCharacterIterator, fontRenderContext);
                        float f = 5.0f;
                        float f2 = 25.0f;
                        lineBreakMeasurer.setPosition(0);
                        while (lineBreakMeasurer.getPosition() < Juke.this.errStr.length()) {
                            TextLayout textLayout = lineBreakMeasurer.nextLayout((float)dimension.width - f - 5.0f);
                            if (!textLayout.isLeftToRight()) {
                                f = (float)dimension.width - textLayout.getAdvance();
                            }
                            textLayout.draw(graphics2D, f, f2 += textLayout.getAscent());
                            f2 += textLayout.getDescent() + textLayout.getLeading();
                        }
                        break block9;
                    }
                    if (Juke.this.currentName != null) break block10;
                    FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
                    TextLayout textLayout = new TextLayout(this.welcomeStr, this.font28, fontRenderContext);
                    float f = (float)((double)(dimension.width / 2) - textLayout.getBounds().getWidth() / 2.0);
                    textLayout.draw(graphics2D, f, dimension.height / 2);
                    if (Juke.this.credits == null) break block9;
                    Juke.this.credits.render(dimension, graphics2D);
                    break block9;
                }
                graphics2D.setFont(this.font24);
                graphics2D.drawString(Juke.this.currentName, 5, this.fm28.getHeight() - 5);
                if (Juke.this.duration <= 0.0) {
                    Juke.this.loading.render(dimension, graphics2D);
                } else {
                    double d = Juke.this.getSeconds();
                    if (Juke.this.midiEOM || Juke.this.audioEOM) {
                        d = Juke.this.duration;
                    }
                    if (d > 0.0) {
                        graphics2D.setFont(this.font42);
                        String string = String.valueOf(d);
                        string = string.substring(0, string.indexOf(46) + 2);
                        int n = (int)this.fm42.getStringBounds(string, graphics2D).getWidth();
                        graphics2D.drawString(string, dimension.width - n - 9, this.fm42.getAscent());
                        int n2 = 30;
                        int n3 = (int)(d / Juke.this.duration * (double)n2);
                        double d2 = (double)(dimension.width - 10) / (double)n2;
                        double d3 = (int)((double)dimension.height * 0.25);
                        double d4 = 0.0;
                        while (d4 < (double)n3) {
                            graphics2D.fill(new Rectangle2D.Double(d4 * d2 + 5.0, (double)dimension.height - d3 - 5.0, d2 - 1.0, d3));
                            d4 += 1.0;
                        }
                        graphics2D.setColor(this.jfcDarkBlue);
                        while (d4 < (double)n2) {
                            graphics2D.fill(new Rectangle2D.Double(d4 * d2 + 5.0, (double)dimension.height - d3 - 5.0, d2 - 1.0, d3));
                            d4 += 1.0;
                        }
                    }
                }
            }
        }

        public void start() {
            this.pbThread = new Thread(this);
            this.pbThread.setName("PlaybackMonitor");
            this.pbThread.start();
        }

        public void stop() {
            if (this.pbThread != null) {
                this.pbThread.interrupt();
            }
            this.pbThread = null;
        }

        public void run() {
            while (this.pbThread != null) {
                try {
                    Thread.sleep(99L);
                }
                catch (Exception exception) {
                    break;
                }
                this.repaint();
            }
            this.pbThread = null;
        }
    }

    class JukeControls
    extends JPanel
    implements ActionListener,
    ChangeListener {
        public JukeControls() {
            this.setLayout(new BoxLayout(this, 1));
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 1));
            jPanel.setBorder(new EmptyBorder(10, 0, 5, 0));
            JPanel jPanel2 = new JPanel();
            Juke.this.startB = this.addButton("Start", jPanel2, Juke.this.sounds.size() != 0);
            Juke.this.pauseB = this.addButton("Pause", jPanel2, false);
            jPanel.add(jPanel2);
            JPanel jPanel3 = new JPanel();
            Juke.this.prevB = this.addButton("<<", jPanel3, false);
            Juke.this.nextB = this.addButton(">>", jPanel3, false);
            jPanel.add(jPanel3);
            this.add(jPanel);
            JPanel jPanel4 = new JPanel(new BorderLayout());
            EmptyBorder emptyBorder = new EmptyBorder(5, 20, 10, 20);
            BevelBorder bevelBorder = new BevelBorder(1);
            jPanel4.setBorder(new CompoundBorder(emptyBorder, bevelBorder));
            jPanel4.add(Juke.this.playbackMonitor);
            Juke.this.seekSlider = new JSlider(0, 0, 100, 0);
            Juke.this.seekSlider.setEnabled(false);
            Juke.this.seekSlider.addChangeListener(this);
            jPanel4.add("South", Juke.this.seekSlider);
            this.add(jPanel4);
            JPanel jPanel5 = new JPanel();
            jPanel5.setLayout(new BoxLayout(jPanel5, 0));
            jPanel5.setBorder(new EmptyBorder(5, 5, 10, 5));
            Juke.this.panSlider = new JSlider(-100, 100, 0);
            Juke.this.panSlider.addChangeListener(this);
            TitledBorder titledBorder = new TitledBorder(new EtchedBorder());
            titledBorder.setTitle("Pan = 0.0");
            Juke.this.panSlider.setBorder(titledBorder);
            jPanel5.add(Juke.this.panSlider);
            Juke.this.gainSlider = new JSlider(0, 100, 80);
            Juke.this.gainSlider.addChangeListener(this);
            titledBorder = new TitledBorder(new EtchedBorder());
            titledBorder.setTitle("Gain = 80");
            Juke.this.gainSlider.setBorder(titledBorder);
            jPanel5.add(Juke.this.gainSlider);
            this.add(jPanel5);
        }

        private JButton addButton(String string, JPanel jPanel, boolean bl) {
            JButton jButton = new JButton(string);
            jButton.addActionListener(this);
            jButton.setEnabled(bl);
            jPanel.add(jButton);
            return jButton;
        }

        public void stateChanged(ChangeEvent changeEvent) {
            JSlider jSlider = (JSlider)changeEvent.getSource();
            int n = jSlider.getValue();
            if (jSlider.equals(Juke.this.seekSlider)) {
                if (Juke.this.currentSound instanceof Clip) {
                    ((Clip)Juke.this.currentSound).setFramePosition(n);
                } else if (Juke.this.currentSound instanceof Sequence) {
                    long l = ((Sequence)Juke.this.currentSound).getMicrosecondLength();
                    Juke.this.sequencer.setMicrosecondPosition(n * 1000);
                } else if (Juke.this.currentSound instanceof BufferedInputStream) {
                    long l = Juke.this.sequencer.getMicrosecondLength();
                    Juke.this.sequencer.setMicrosecondPosition(n * 1000);
                }
                Juke.this.playbackMonitor.repaint();
                return;
            }
            TitledBorder titledBorder = (TitledBorder)jSlider.getBorder();
            String string = titledBorder.getTitle();
            if (string.startsWith("Pan")) {
                string = string.substring(0, string.indexOf(61) + 1) + String.valueOf((double)n / 100.0);
                if (Juke.this.currentSound != null) {
                    Juke.this.setPan();
                }
            } else if (string.startsWith("Gain")) {
                string = string.substring(0, string.indexOf(61) + 1) + String.valueOf(n);
                if (Juke.this.currentSound != null) {
                    Juke.this.setGain();
                }
            }
            titledBorder.setTitle(string);
            jSlider.repaint();
        }

        public void setComponentsEnabled(boolean bl) {
            Juke.this.seekSlider.setEnabled(bl);
            Juke.this.pauseB.setEnabled(bl);
            Juke.this.prevB.setEnabled(bl);
            Juke.this.nextB.setEnabled(bl);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JButton jButton = (JButton)actionEvent.getSource();
            if (jButton.getText().equals("Start")) {
                if (Juke.this.credits != null) {
                    Juke.this.credits.interrupt();
                }
                Juke.this.paused = false;
                Juke.this.num = Juke.this.table.getSelectedRow();
                Juke.this.num = Juke.this.num == -1 ? 0 : Juke.this.num;
                Juke.this.start();
                jButton.setText("Stop");
                this.setComponentsEnabled(true);
            } else if (jButton.getText().equals("Stop")) {
                Juke.this.credits = new Credits();
                Juke.this.credits.start();
                Juke.this.paused = false;
                Juke.this.stop();
                jButton.setText("Start");
                Juke.this.pauseB.setText("Pause");
                this.setComponentsEnabled(false);
            } else if (jButton.getText().equals("Pause")) {
                Juke.this.paused = true;
                if (Juke.this.currentSound instanceof Clip) {
                    ((Clip)Juke.this.currentSound).stop();
                } else if (Juke.this.currentSound instanceof Sequence || Juke.this.currentSound instanceof BufferedInputStream) {
                    Juke.this.sequencer.stop();
                }
                Juke.this.playbackMonitor.stop();
                Juke.this.pauseB.setText("Resume");
            } else if (jButton.getText().equals("Resume")) {
                Juke.this.paused = false;
                if (Juke.this.currentSound instanceof Clip) {
                    ((Clip)Juke.this.currentSound).start();
                } else if (Juke.this.currentSound instanceof Sequence || Juke.this.currentSound instanceof BufferedInputStream) {
                    Juke.this.sequencer.start();
                }
                Juke.this.playbackMonitor.start();
                Juke.this.pauseB.setText("Pause");
            } else if (jButton.getText().equals("<<")) {
                Juke.this.paused = false;
                Juke.this.pauseB.setText("Pause");
                Juke.this.num = Juke.this.num - 1 < 0 ? Juke.this.sounds.size() - 1 : Juke.this.num - 2;
                Juke.this.bump = true;
            } else if (jButton.getText().equals(">>")) {
                Juke.this.paused = false;
                Juke.this.pauseB.setText("Pause");
                Juke.this.num = Juke.this.num + 1 == Juke.this.sounds.size() ? -1 : Juke.this.num;
                Juke.this.bump = true;
            }
        }
    }
}

