#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "assignment1.h"



int my_ceil(float a) {
  if (a == (int) a || a < 0)
    return (int)a;
  else // (a > 0)
    return (int)a + 1;
}

int my_floor(float a) {
  if (a == (int) a || a > 0)
    return (int)a;
  else // (a < 0)
    return (int)a - 1;
}

int sum_ints_interval(float x, float y) {
  if (x > y) {
    float tmp = x;
    x = y;
    y = tmp;
  }
  // now x < y
  int int_x = my_ceil(x);
  int int_y = my_floor(y);
  return (int_x+int_y)*(int_y-int_x+1)/2;
}


int hide_digits(char* str) {
  int count = 0;

  int len = strlen(str); 
  for (int i = 0; i < len; i++)
    if (str[i] >= '0' && str[i] <= '9') {
      str[i] = '*';
      count++;
    }
  // we could also implement it without calling strlen, using a while loop

  return count;
}


// helper function: count the number of appearances of elt in array of length n
int count(const int* arr, int n, int elt) {
  int ret=0;
  for (int i=0; i<n; i++)
    if (arr[i]==elt)
      ret++;
  return ret;
}

int most_frequent(const int* arr, int n) {
  // max holds the most frequent element
  // max_count holds the frequency of max
  int max, max_count;

  // initiate max to arr[0]
  max=arr[0];
  max_count = count(arr, n, max);

  for (int i=1; i<n; i++) {
    // if arr[i] appear more times that max, update max and max_count
    int arr_i_count = count(arr, n, arr[i]);
    if (arr_i_count > max_count) {
      max = arr[i];
      max_count = arr_i_count;
    }
  }
  return max;
}  


void swap(int* x, int* y) {
  int tmp = *x;
  *x = *y;
  *y = tmp;
}

void sort3(int* a, int* b, int* c)
{
  if (*a > *b)
    swap(a,b);
  if (*b > *c)
    swap(b,c);
  if (*a > *b)
    swap(a,b);
}

// returns the i'th digit of the number (counting from the right)
// or returns 0 if i >= strlen(num)
int get_digit(const char* num, int i) {
  int len = strlen(num); 
  if (i >= len)
    return 0;
  else
    return num[len-i-1] - '0';
}

char* str_sum(const char* num1, const char* num2) {
  int len1 = strlen(num1);
  int len2 = strlen(num2);
  int max_len = len1 > len2 ? len1 : len2;
  // +2 because we need a char for '\0' and maybe we need another digit
  char* sum = (char*) malloc((max_len+2) * sizeof(char));
  
  // in the end, if we don't have the carry, we'll move everything by 1 to the left
  sum[max_len+1]='\0';

  int i;
  int sum_of_digits;
  int carry=0;

  for (i=0;i<max_len;i++) {
    sum_of_digits = get_digit(num1,i) + get_digit(num2,i) + carry;
    sum[max_len-i] = (sum_of_digits % 10) + '0';
    carry = (sum_of_digits/10); // if sum_of_digits>=10 => carry=1
  }
  if (carry == 1)
    sum[0] = '1';
  else
    memmove(sum, sum+1,(max_len+1) * sizeof(char)); // move everything by 1 to the left 

  return sum;
}
