#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "assignment2.h"

// The file format is the following:
// Each entry corresponds to 4 lines in the file
// int - strlen(username)
// string - username
// int - strlen(password)
// string - password
//For example:
//------
//11
//igorshinkar
//30
//A famous quote from some movie
//EOF
//------
// Note that if a password contains \n, then
// (1) it will count toward the length of the string, and 
// (2) it will add a line to the file.
// This means some username/passwor might be more than one line long
// For example:
//------
//10
//HaikuLover
//46
//Climb Mount Fuji,
//O snail,
//but slowly, slowly.
//EOF
//------
// In the password above the lengths of the lines are 17+8+19 and we add 2 for the two '\n's

int add_user_password(const char* file_name,
                    const char* username, const char* password) {

  // check if user_name is already in the file
  int check_ans =  check_user_password(file_name, username, password);
  if (check_ans==1 || check_ans==-3) {
    return 0; // easy peasy
  }

  FILE *file_ptr = fopen(file_name, "a");
  // "a" - we will append the new song to the end of the file.
  //  If the file does not exist, it will be created.

  // if can't open file
  if (file_ptr == NULL) 
    return -1;

  fprintf(file_ptr, "%d\n", (int) strlen(username));
  fprintf(file_ptr, "%s\n", username);
  fprintf(file_ptr, "%d\n", (int) strlen(password));
  fprintf(file_ptr, "%s\n", password);

  // don't forget to close the file
  fclose(file_ptr);

  return 1;
}


int check_user_password(const char* file_name,
                    const char* username, const char* password) {


  FILE *file_ptr= fopen(file_name, "r");

  if (!file_ptr) { //same as (file_prt == NULL)
    // file not found
    return -1;
  }

  // a username we read from file
  int user_len;
  char* user_read;
  // a password we read from file
  int pass_len;
  char* pass_read;

  // indicates that we reached end of file
  bool end_of_file = false;

  while (!end_of_file) {
    // read length of username
    if(fscanf(file_ptr, "%d", &user_len) == EOF) {
      end_of_file = true;
    }
    else { // not EOF
      fgetc(file_ptr); // read one extra char: '\n' after user_len
      // allocate user_len+1 chars to read the username (+1 for the '\0')
      user_read = (char*) malloc((user_len+1)*sizeof(char));
      fread(user_read, sizeof(char), user_len, file_ptr);
      fgetc(file_ptr); // read one extra char from the file: '\n' after user_read
      user_read[user_len] = '\0'; // set string terminator for user_read

      // read the definition
      fscanf(file_ptr, "%d", &pass_len);
      fgetc(file_ptr); // read \n afterpass_len
      // allocate pass_len+1 chars to read the password (+1 for the '\0')
      pass_read = (char*) malloc((pass_len+1)*sizeof(char));
      fread(pass_read, sizeof(char), pass_len, file_ptr);
      fgetc(file_ptr); // read one extra char from the file: '\n' after pass_read
      pass_read[pass_len] = '\0'; // set string terminator for pass_read

      if (strcmp(username, user_read) == 0) {
        int ret;
        if (strcmp(password, pass_read)==0)
          ret=1; // password matches, return 1
        else
          ret=-3; // password doesn't match, return -3
        // don't forget to free the strings
        free(user_read);
        free(pass_read);
        // don't forget to close the file
        fclose(file_ptr);
        return ret;
      }
      else {
        free(user_read);   // free both
        free(pass_read);  // before reading the next pair
      }
    }
  }

  fclose(file_ptr);
  return -2; // username not found
}


/* Question 2 */

int64_t fib3(unsigned int n) {
  // implement me
  if (n==0 || n==1)
    return 0;
  if (n==2)
    return 1;
  int64_t* a = (int64_t*) malloc ((n+1)*sizeof(int64_t));
  a[0] = 0; a[1] = 0; a[2] = 1;
  for (int i = 3; i<=n; i++)
    a[i] = a[i-1] + a[i-2] + a[i-3];

  
  int64_t ret = a[n];
  free(a);

  return ret;
}


/* Question 3 */

int count_tokens(const char* str, char delim) {
  int count=0;
  bool is_prev_delim = true;

  // read the string char by char
  // increase the counter if str[i] is not delim, but str[i-1] is delim
  for (int i=0; str[i] != 0; i++) {
    if (str[i] == delim) { // if the char is delim
      is_prev_delim = true; // update the flag
    }
    else { // char is not delim
      if (is_prev_delim) {
        count++;  // increase count
        is_prev_delim = false; // update the flag
      }
    }
  }
  return count;
}


char** get_tokens(const char* str, char delim) {
  int count = count_tokens(str, delim);
  if (count==0)
    return NULL;
 
  char** ret = (char**) malloc(sizeof(char*)*(count+1));
  if (ret==NULL) {
    // printf("malloc failed");
    return NULL;
  }

  // pointer to the beginning and end of a token
  const char* token_start = str;
  const char* token_end;
  // length of a token (equal to token_end-token_start)
  int len_str_i;

  // create the i'th token
  for (int i=0; i<count; i++) {

    // find the beginning of the first token
    while (*token_start==delim)
      token_start++;
   
    // find end of token
    token_end = token_start+1;
    while (*token_end != 0 && *token_end!=delim)
      token_end++;
   
    // compute the length of the token
    // and allocate memory for the token
    len_str_i = token_end-token_start;
    ret[i] = (char*) malloc((len_str_i+1)*sizeof(char));
    strncpy(ret[i], token_start, len_str_i);
    ret[i][len_str_i] = '\0';
    token_start = token_end+1;
  }

  ret[count] = NULL;

  return ret;
}
