#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdbool.h>
#include "assignment2.h"

#define LEN 100
bool test_q1_13() {
  const char* filename = "test13_passwords.txt";
  char users[LEN][20];
  char passwords[LEN][20];
  for (int i = 0; i < LEN; i++) {
    sprintf(users[i], "user%d", i);
    sprintf(passwords[i], "pass%d", i);
  }

  bool ok_flag = true;

  for (int i = 0; i < LEN; i++) {
    if (add_user_password(filename, users[i], passwords[i]) != 1) { // new user: return 1
      if (ok_flag) // print the error message only once
        printf("Q1-13 ERROR : adding %d'th user/pass\n", i);
      ok_flag = false;
    }
  }

  // test correct user/pass: return 1
  for (int i = 0; i < LEN; i++) {
    if (check_user_password(filename, users[i], passwords[i]) != 1) {
      if (ok_flag) // print the error message only once
        printf("Q1-13 ERROR : checking %d'th user/pass\n", i);
      ok_flag = false;
    }
  }

  // test incorrect user/pass: return -3
  for (int i = 3; i < LEN; i++) {
    if (check_user_password(filename, users[i], passwords[i-1]) != -3) {
      if (ok_flag) // print the error message only once
        printf("Q1-13 ERROR : failed on incorrect %d'th user/pass\n", i);
      ok_flag = false;
    }
  }

  if (ok_flag)
    printf("Q1-13 ok\n");

  return ok_flag;
}



int main()  {
  test_q1_13();
 
  return 0;
}
