#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdbool.h>
#include "assignment2.h"



#define LEN 100
#define PASS_LEN 10000

// sets the password in place
void set_user_pass(int i, char* user, char* password) {
  sprintf(user, "user%d", i);
  for (int i = 0; i < PASS_LEN; i++)
    password[i] = (30 + i%200);
  password[PASS_LEN-1] = 0;

}

// all same password
bool test_q1_16() {
  const char* filename = "test16_passwords.db";
  char users[LEN][20];
  char passwords[LEN][PASS_LEN];
  for (int i = 0; i < LEN; i++)
    set_user_pass(i, users[i], passwords[i]);

  bool ok_flag = true;

  for (int i = 0; i < LEN; i++) {
    if (add_user_password(filename, users[i], passwords[i]) != 1) { // new user: return 1
      if (ok_flag) // print the error message only once
        printf("Q1-16 ERROR : adding %d'th user/pass\n", i);
      ok_flag = false;
    }
  }

  // test correct user/pass: return 1
  for (int i = 0; i < LEN; i++) {
    if (check_user_password(filename, users[i], passwords[i]) != 1) {
      if (ok_flag) // print the error message only once
        printf("Q1-16 ERROR : checking %d'th user/pass\n", i);
      ok_flag = false;
    }
  }

  // test incorrect user/pass: return -3
  for (int i = 3; i < LEN; i++) {
    if (check_user_password(filename, users[i], "wrong password") != -3) {
      if (ok_flag) // print the error message only once
        printf("Q1-16 ERROR : failed on incorrect %d'th user/pass\n", i);
      ok_flag = false;
    }
  }

  if (ok_flag)
    printf("Q1-16 ok\n");

  return ok_flag;
}



int main()  {
  test_q1_16();
 
  return 0;
}
