#ifndef ASSIGNMENT4_H
#define ASSIGNMENT4_H

#include <stdlib.h>
#include <stdbool.h>
#include <stdint.h>

#include "lib/queue.h"
#include "lib/BTnode.h"

/* Question 1 */

// returns the size of the queue
// when the function returns, q should be in the same state
// as it was in the beginning
int queue_size(queue_t* q);


// checks if the two queues are equal
// when the function returns, q1 and q2 should be in the same state
// as they were in the beginning
bool queue_equal(queue_t* q1, queue_t* q2);


/* Question 2 */

// the function gets a root of a Binary Tree, and a boolean predicate pred.
// it returns a pointer to a node whose value satisfies pred(node->value)==true.
// if no such node is not found, the function returns NULL.
// if there are several such nodes, the function may return any of them.
BTnode_t* find(BTnode_t* root, bool (*pred)(int));


// the function gets a root of a Binary Tree of ints, and a function f.
// it applies f to the value of each node in the tree
void map(BTnode_t* root, int (*f)(int));

/* Question 3 */


// gets a node in a binary tree
// returns the next node in the inorder traversal of the tree.
BTnode_t* next_inorder(BTnode_t* node);

#endif
