#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdbool.h>

#include "assignment4.h"

bool check_and_free(queue_t* q, int* ar, int n) {
  bool ret = true;
  for (int i = 0; i < n; i++)
    if (queue_is_empty(q) || dequeue(q)!=ar[i])
      ret = false;

  if (!queue_is_empty(q))
      ret = false;
  queue_free(q);
  return ret;
}

void test_q1_size()  {
  // create the strings
  int n = 5;
  int nums[] = {10,20,30,40,50};

  queue_t* q = queue_create();
  for (int i = 0; i < n; i++)
    enqueue(q, nums[i]);

  // testing the answer
  bool flag_ok = true;
  if (queue_size(q) != 5)
    flag_ok = false;
  if (!check_and_free(q, nums, 5))
    flag_ok = false;
  
  if (flag_ok)
    printf("Q1-size ok\n");
  else
    printf("Q1-size-1 ERROR\n");
}



void test_q1_equal_1()  {
  // create the strings
  int n = 5;
  int nums[] = {10,20,30,40,50};

  queue_t* q1 = queue_create();
  queue_t* q2 = queue_create();
  for (int i = 0; i < n; i++) {
    enqueue(q1, nums[i]);
    enqueue(q2, nums[i]);
  }

  // testing the answer
  bool flag_ok = true;
  if (queue_equal(q1, q2) == false)
    flag_ok = false;
  if (!check_and_free(q1, nums, n) || !check_and_free(q2, nums, n))
    flag_ok = false;
  
  if (flag_ok)
    printf("Q1-equal-1 ok\n");
  else
    printf("Q1-equal-1 ERROR\n");
}

void test_q1_equal_2()  {
  // create the strings
  int n1 = 5;
  int nums1[] = {10,20,30,40,50};
  int n2 = 5;
  int nums2[] = {10,20,30,40};

  queue_t* q1 = queue_create();
  queue_t* q2 = queue_create();
  for (int i = 0; i < n1; i++)
    enqueue(q1, nums1[i]);
  for (int i = 0; i < n2; i++)
    enqueue(q2, nums2[i]);

  // testing the answer
  bool flag_ok = true;
  if (queue_equal(q1, q2) == true)
    flag_ok = false;
  if (!check_and_free(q1, nums1, n1) || !check_and_free(q2, nums2, n2))
    flag_ok = false;
  
  if (flag_ok)
    printf("Q1-equal-2 ok\n");
  else
    printf("Q1-equal-2 ERROR\n");
}

bool is_even(int x) { return x%2==0;}

void test_q2_find_1() {
/***
// creates the following tree
//      3
//    /   \
//   5      4
//  / \
// 2   1
//
****/

  BTnode_t* three = create_node(3);
  BTnode_t* five = create_node(5);
  BTnode_t* four = create_node(4);
  BTnode_t* two = create_node(2);
  BTnode_t* one = create_node(1);

  set_left_child(three, five);
  set_right_child(three, four);
  set_left_child(five, two);
  set_right_child(five, one);

  BTnode_t* ans = find(three, is_even);

  if (ans && (ans==two || ans==four))
    printf("Q2-find-1 ok\n");
  else
    printf("Q2-find-1 ERROR\n");

  BT_free(three);
}

bool greater_than_10(int x) {
  return x>10;
}

void test_q2_find_2() {
/***
// creates the following tree
//      3
//    /   \
//   5      4
//  / \
// 2   1
//
****/

  BTnode_t* three = create_node(3);
  BTnode_t* five = create_node(5);
  BTnode_t* four = create_node(4);
  BTnode_t* two = create_node(2);
  BTnode_t* one = create_node(1);

  set_left_child(three, five);
  set_right_child(three, four);
  set_left_child(five, two);
  set_right_child(five, one);

  BTnode_t* ans = find(three, greater_than_10);

  if (ans == NULL)
    printf("Q2-find-2 ok\n");
  else
    printf("Q2-find-2 ERROR\n");

  BT_free(three);
}

int square(int x) {
  return x*x;
}

void test_q2_map() {
/***
// creates the following tree
//      3
//    /   \
//   5      4
//  / \
// 2   1
//
****/
  BTnode_t* one = create_node(1);
  BTnode_t* two = create_node(2);
  BTnode_t* three = create_node(3);
  BTnode_t* four = create_node(4);
  BTnode_t* five = create_node(5);
  set_left_child(three, five);
  set_right_child(three, four);
  set_left_child(five, two);
  set_right_child(five, one);

  map(three, square);

  if (one->value==1 && two->value==4 && three->value==9 && four->value==16 && five->value==25)
    printf("Q2-map ok\n");
  else
    printf("Q2-map ERROR\n");

  BT_free(three);

}

void test_q3_1() {
/***
// creates the following tree
//      3
//    /   \
//   5      4
//  / \
// 2   1
//
****/
  BTnode_t* one = create_node(1);
  BTnode_t* two = create_node(2);
  BTnode_t* three = create_node(3);
  BTnode_t* four = create_node(4);
  BTnode_t* five = create_node(5);
  set_left_child(three, five);
  set_right_child(three, four);
  set_left_child(five, two);
  set_right_child(five, one);

  int expected_ans[] = {2,5,1,3,4};

  bool flag_ok = true;
  BTnode_t* node = two;
  for (int i = 1; i < 5 && flag_ok; i++) {
    node = next_inorder(node);
    if (node == NULL || node->value != expected_ans[i])
      flag_ok = false;
  }

  if (next_inorder(node) != NULL)
    flag_ok = false;


  if (flag_ok)
    printf("Q3-1 ok\n");
  else
    printf("Q3-1 ERROR\n");
}

#define TREE_SIZE 5
void test_q3_2() {
  // build a long skinny tree going only left
  //            0
  //           /
  //          1
  //         /
  //        2
  //      ...
  //      /
  //   TREE_SIZE-1

  int i;
  BTnode_t* root_zero = create_node(0);
  BTnode_t* node = root_zero;
  for (i = 1; i < TREE_SIZE; i++) {
      set_left_child(node, create_node(i));
      node = node->left;
  }
  // node points to the bottom: TREE_SIZE-1

  bool flag_ok = true;
  for (int i = 0; i < TREE_SIZE-1 && flag_ok; i++) {
    node = next_inorder(node);
    if (node == NULL || node->value != TREE_SIZE-2-i)
      flag_ok = false;
  }

  if (next_inorder(node) != NULL)
    flag_ok = false;


  if (flag_ok)
    printf("Q3-2 ok\n");
  else
    printf("Q3-2 ERROR\n");
}

// when testing your code, it may be convenient 
// to comment out some of the test cases
// and focus only on the one you are working on right now
int main() {
  test_q1_size();

  test_q1_equal_1();
  test_q1_equal_2();

  test_q2_find_1();
  test_q2_find_2();
  test_q2_map();

  test_q3_1();
  test_q3_2();
  
  return 0;
}
