#ifndef ASSIGNMENT5_H
#define ASSIGNMENT5_H

#include <stdio.h>
#include <stdlib.h>
#include <stdbool.h>
#include <stdint.h>
#include <string.h>

#include "lib/BTnode.h"
#include "lib/BST.h"

typedef struct {
    int min;
    int max;
} min_max;


// the function gets a root of a Binary Tree,
// and checks if it is a Binary Search Tree.
bool is_BST(BTnode_t* root);


// the function gets a Binary Search Tree,
// and returns the the minimal and the maximal element in the tree
min_max BST_min_max(BST_t* bst);


// the function gets a Binary Search Tree,
// and returns an array that contains all values from the tree
// sorted in the non-decreasing order.
int* BST_to_array(BST_t* bst);


// the function gets an array of length n of ints sorted in the non-decreasing order
// and returns a Binary Search Tree containing all the values in the array,
// such that the depth of the tree is at most log_2(n)+1.
BST_t* sorted_array_to_BST(int* ar, int n);


// the function gets an array of length n, containing the pre order traversal
// of a Binary Search Tree, and returns the Binary Search Tree.
BST_t* preorder_to_BST(int* preorder, int n);


#endif
