#include <stdio.h>
#include <stdlib.h>

#include "BTnode.h"

BTnode_t* create_node(int val) {
    BTnode_t* newNode = (BTnode_t*) malloc(sizeof(BTnode_t));
    newNode->value = val;
    newNode->left = NULL;
    newNode->right = NULL;
    newNode->parent = NULL;
    return newNode;
}

int is_leaf(BTnode_t* node) {
  return (node->left == NULL && node->right == NULL);
}

int max(int x, int y) {
  return x>y ? x : y;
}

int height(BTnode_t* root) {
  if (root == NULL)
    return -1;  // for consistency with leaf having height 1
  else if (is_leaf(root))
    return 0;
  else
    return max(height(root->left), height(root->right))+1;
}

int size(BTnode_t* root) {
  if (root == NULL)
    return 0;  // for consistency with leaf having height 1
  else
    return size(root->left) + size(root->right) + 1;
}

void set_left_child(BTnode_t* parent, BTnode_t* left_child) {
  parent->left = left_child;
  left_child->parent = parent;
}

void set_right_child(BTnode_t* parent, BTnode_t* right_child) {
  parent->right = right_child;
  right_child->parent = parent;
}

void preOrder(BTnode_t* root) {
  if (root == NULL)
    return;  

  printf("%d ", root->value);
  preOrder(root->left);
  preOrder(root->right);
}

void inOrder(BTnode_t* root) {
  if (root == NULL)
    return;  

  inOrder(root->left);
  printf("%d ", root->value);
  inOrder(root->right);
}

void postOrder(BTnode_t* root) {
  if (root == NULL)
    return;  

  postOrder(root->left);
  postOrder(root->right);
  printf("%d ", root->value);
}


void free_subtree(BTnode_t* root) {
  if (root) {
    free_subtree(root->left);
    free_subtree(root->right);
    free(root);
  }
}

