#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdbool.h>

#include "assignment5.h"

  /* creates the tree
  //      4
  //    /   \
  //   2     8
  //  / \   / \
  // 1   3 6   9
  //            \
  //            10
  */
BST_t* create_tree() {
  BST_t* bst = BST_create();
  BST_insert(bst, 4);
  BST_insert(bst, 2);
  BST_insert(bst, 8);
  BST_insert(bst, 6);
  BST_insert(bst, 3);
  BST_insert(bst, 1);
  BST_insert(bst, 9);
  BST_insert(bst, 10);
  return bst;
}

bool tree_equal(BTnode_t* root1, BTnode_t* root2) {
  if (root1==NULL && root2==NULL)
    return true;
  if (root1==NULL || root2==NULL)
    return false;
  if (root1->value != root2->value)
    return false;
  return tree_equal(root1->left, root2->left) && tree_equal(root1->right, root2->right);
}

// testing is_BST 
void test_q1()  {

  BTnode_t* n1 = create_node(1);
  BTnode_t* n2 = create_node(2);
  BTnode_t* n3 = create_node(3);
  BTnode_t* n4 = create_node(4);
  BTnode_t* n5 = create_node(5);
  BTnode_t* n6 = create_node(6);
  BTnode_t* n7 = create_node(7);


  set_left_child(n4, n1);
  set_right_child(n4, n5);
  set_right_child(n1, n3);
  set_left_child(n5, n2);
  set_right_child(n5, n6);
  set_right_child(n6, n7);
/*
//       4
//     /   \
//    1     5
//     \   / \
//      3 2   6
//             \
//              7
*/ 

  bool ans1 = is_BST(n4);
  bool ans2 = is_BST(n5);

  free_subtree(n4);

  if (ans1 == false && ans2 == true)
    printf("Q1 ok\n");
  else
    printf("Q1 ERROR\n");
}


// testing BST_min_max 
void test_q2()  {
  BST_t* bst = create_tree(); 
  min_max ans = BST_min_max(bst);
  BST_free(bst);

  if (ans.min == 1 && ans.max == 10)
    printf("Q2 ok\n");
  else
    printf("Q2 ERROR\n");
}


// testing BST_to_array 
void test_q3()  {
  BST_t* bst = create_tree();
  int n = BST_size(bst);
  int* a = BST_to_array(bst);
  int expected_ans[] = {1,2,3,4,6,8,9,10};


  bool okFlag = true;

  if (a == NULL)
    okFlag =false;
  else {
    for (int i = 0; i < n && okFlag; i++)
      if (a[i] != expected_ans[i])
        okFlag = false;
    free(a);
  }
  BST_free(bst);

  if (okFlag)
    printf("Q3 ok\n");
  else
    printf("Q3 ERROR\n");
}


// testing sorted_array_to_BST and BST_to_array 
void test_q4()  {
  int sorted_arr[] = {1,2,3,4,6,8,9,10};

  BST_t* ans = sorted_array_to_BST(sorted_arr, 8);

  bool okFlag = true;

  if (ans == NULL) {
    okFlag = false;
  }
  else {
    okFlag &= (BST_depth(ans) <= 4);
    okFlag &= (BST_size(ans) == 8);
    int* a = BST_to_array(ans);
    if (a == NULL)
      okFlag = false;
    else {
      for (int i = 0; i < 8 && okFlag; i++)
        if (a[i] != sorted_arr[i])
          okFlag = false;
      free(a);
    }
    BST_free(ans);
  }

  if (okFlag)
    printf("Q4 ok\n");
  else
    printf("Q4 ERROR\n");
}


// testing preorder_to_BST 
void test_q5()  {
  int preorder[] = {4,2,1,3,8,6,9,10};
  BST_t* ans = preorder_to_BST(preorder,8);

  bool okFlag = true;
  if (ans == NULL)
    okFlag = false;
  else {
    BST_t* expected_ans = create_tree();
    okFlag = tree_equal(ans->root, expected_ans->root);
    BST_free(expected_ans);
    BST_free(ans);
  }
  
  if (okFlag)
    printf("Q5 ok\n");
  else
    printf("Q5 ERROR\n");
}

// when testing your code, it may be convenient 
// to comment out some of the test cases
// and focus only on the one you are working on right now
int main() {
  test_q1();
  test_q2();
  test_q3();
  test_q4();
  test_q5();
  
  return 0;
}
