#include <stdio.h>
#include <stdlib.h>
#include <string.h>

typedef struct {
  int x;
  int y;
} point;
 

// generic swap
void swap(void* a, void* b, size_t s)  {
  void* tmp = malloc(s);
  memcpy(tmp, a, s);  // copy a to tmp
  memcpy(a, b, s);    // copy b to a
  memcpy(b, tmp, s); // copy tmp to b
  free(tmp);
}


void print_ints(int* a, int len) {
  for(int i=0; i<len; i++)
    printf("%d ", a[i]);
  printf("\n");
}
  
int main() {
  printf("Swapping  points:\n");
  point p1 = {0,0};
  point p2 = {3,3};
  printf("p1 = (%d, %d)  ", p1.x, p1.y);
  printf("p2 = (%d, %d)\n", p2.x, p2.y);
  swap(&p1, &p2, sizeof(point));
  printf("swapping...\n");
  printf("p1 = (%d, %d)  ", p1.x, p1.y);
  printf("p2 = (%d, %d)\n", p2.x, p2.y);
  

  printf("\n\nSwapping ints in an array:\n");
  
  int a[] = {6,7,8,9,10};
  printf("before:  ");
  print_ints(a,5);

  swap(&a[0], &a[2], sizeof(int));
  printf("after:  ");
  print_ints(a,5);

  return 0;
}  
