#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define LENGTH 10


// used for appying qsort on array of ints
// if the function returns <0, then a must be before b
// if the function returns >0  then a must be after b
int compare_ints_X(const void* a, const void* b) {
  int n1 = *(int*)a;
  int n2 = *(int*)b;

  return n1-n2;
}

void check_sorted(int* ar, int n) {
  // check that the array is sorted  
  for (int i=1; i<LENGTH; i++) {
    if (ar[i-1]>ar[i]) {
      printf("Array not sorted: ar[%d] = %d,  ar[%d] = %d\n---\n", i-1, ar[i-1], i, ar[i]);
      return;
    }
  }
  printf("looks sorted...\n");
}


void set_rand(int* ar, int n) {
  srand(0);
  int i;
  for(i=0; i<n; i++)
    ar[i] = rand();
}


int main() {

  // create a random array
  int ar[LENGTH];
  set_rand(ar, LENGTH);

  printf("before ar = : ");
  for(int i=0; i<LENGTH; i++)
    printf("%d ", ar[i]);
  printf("\n");

//  printf("qsort on array of length %d...\n---\n", LENGTH);

  // the generic sorting algorithm implemented in C -- requires comparison function
  qsort(ar, LENGTH, sizeof(int), compare_ints_X);

  printf("ar = : ");
  for(int i=0; i<LENGTH; i++)
    printf("%d ", ar[i]);
  printf("\n");

  printf("\n");
  check_sorted(ar, LENGTH);
  printf("\n");

  return 0;
}
