#include <stdio.h>
#include <stdlib.h>

#define LEN 5

typedef struct {
  int x;
  int y;
} point;

int* create_array_of_ints() {
  int* arr_of_ints = malloc(LEN*sizeof(int));
  for (int i=0;i<LEN;i++)
    arr_of_ints[i] = i*i;
  return arr_of_ints;
}

point* create_array_of_points() {
  point* arr_of_points = malloc(LEN*sizeof(point));
  for (int i=0;i<LEN;i++) {
    arr_of_points[i].x = 10+i;
    arr_of_points[i].y = 40-i;
  }
  return arr_of_points;
}


void print_point(void* ptr) {
// cast into point* and print the point
  point* p = (point*)ptr;
  printf("(%d, %d)\n", p->x, p->y);
}


void print_int(void* ptr) {
// cast into int* and print the int
  int* n = (int*)ptr;
  printf("%d\n", *n);
}

// the function gets a generic array, sizeof item, length of the array
// and it gets a function that prints one item
void print_array(void* arr, size_t size_of_item, int len, void(*print_item)(void*)) {
  for (int i=0;i<len;i++) {
    printf("arr[%d] = ", i);
    print_item(arr+i*size_of_item); // run print_item(the ith element)
  }
}


int main() {

  int* arr_of_ints = create_array_of_ints();
  printf("printing array of ints:\n");
  print_array(arr_of_ints, sizeof(int), LEN, print_int);

  point* arr_of_points = create_array_of_points();
  printf("printing array of points:\n");
  print_array(arr_of_points, sizeof(point), LEN, print_point);

  return 0;
} 