package testcases;

import assignment2.MyStackOperations;
import basicdatastructures.stack.*;

import java.lang.invoke.MethodHandles;

public class Test23 {

    private static  <T> boolean testEqualAndEmpty(Stack<T> s1, Stack<T> s2) {
        while (!s1.isEmpty() && !s2.isEmpty())
            if (s1.pop() != s2.pop())
                return false;
        return s1.isEmpty() && s2.isEmpty();
    }

    public static boolean test() {

        int a[] = {1,2,3,4,5,6,7,8,9,10};

        Stack<Integer> s = new StackLinkedListBased<Integer>();
        for (int i = 0; i < a.length; i++) {
            s.push(a[i]);
        }
        if (MyStackOperations.size(s) != a.length)
            return false;

        s.push(7);
        if (MyStackOperations.size(s) != a.length+1)
            return false;

        s.pop();
        if (MyStackOperations.size(s) != a.length)
            return false;

        Stack<Integer> s2 = new StackLinkedListBased<Integer>();
        for (int i = 0; i < a.length; i++) {
            s2.push(a[i]);
        }

        return testEqualAndEmpty(s, s2);
    }

    public static void main(String[] args) {
        String className = MethodHandles.lookup().lookupClass().getSimpleName();

        try {
            if (test())
                System.out.println(className + " ok");
            else
                System.out.println(className + " ERROR");
        } catch (Exception e) {
            System.out.println(className + " EXCEPTION" + e);
        }
    }
}
