package testcases;

import assignment2.MyStackOperations;
import basicdatastructures.stack.Stack;
import basicdatastructures.stack.StackLinkedListBased;
import geomerticshapes.Circle;
import geomerticshapes.GeometricShape;

import java.lang.invoke.MethodHandles;

public class Test24 {

    private static  <T> boolean testEqualAndEmpty(Stack<T> s1, Stack<T> s2) {
        while (!s1.isEmpty() && !s2.isEmpty())
            if (s1.pop() != s2.pop())
                return false;
        return s1.isEmpty() && s2.isEmpty();
    }

    public static boolean test() {

        Circle c = new Circle(5, 10, 15);
        int n = 50;

        Stack<GeometricShape> s1 = new StackLinkedListBased<GeometricShape>();
        Stack<GeometricShape> s2 = new StackLinkedListBased<GeometricShape>();
        for (int i = 0; i < n; i++) {
            s1.push(c);
            s2.push(c);
        }
        for (int i = 0; i < n; i++) {
            Circle d = new Circle(1, 2, 3);
            s1.push(d);
            s2.push(d);
        }

        if (MyStackOperations.size(s1) != n*2)
            return false;

        if (MyStackOperations.size(s1) != n*2)
            return false;


        return testEqualAndEmpty(s1,s2);

	}

	public static void main(String[] args) {
		String className = MethodHandles.lookup().lookupClass().getSimpleName();

		try {
			if (test())
				System.out.println(className + " ok");
			else
				System.out.println(className + " ERROR");
		} catch (Exception e) {
			System.out.println(className + " EXCEPTION" + e);
		}
	}
}
