package testcases;

import assignment2.MyStackOperations;
import basicdatastructures.stack.Stack;
import basicdatastructures.stack.StackLinkedListBased;

import java.lang.invoke.MethodHandles;

public class Test26 {

    private static  <T> boolean testEqualAndEmpty(Stack<T> s1, Stack<T> s2) {
        while (!s1.isEmpty() && !s2.isEmpty())
            if (s1.pop() != s2.pop())
                return false;
        return s1.isEmpty() && s2.isEmpty();
    }

    public static boolean test() {
        int a[] = {5, 50, 500};
        Stack<Integer> s = new StackLinkedListBased<Integer>();
        for (int i = 0; i < a.length; i++) {
            s.push(a[i]);
        }

        if (s.isEmpty())
            return false;

        if (MyStackOperations.removeBottom(s) != a[0])
            return false;

        if (s.pop() != a[2])
            return false;

        if (s.pop() != a[1])
            return false;

        if (!s.isEmpty())
            return false;

        return true;
	}

	public static void main(String[] args) {
		String className = MethodHandles.lookup().lookupClass().getSimpleName();

		try {
			if (test())
				System.out.println(className + " ok");
			else
				System.out.println(className + " ERROR");
		} catch (Exception e) {
			System.out.println(className + " EXCEPTION" + e);
		}
	}
}
