package testcases;

import assignment2.MyStackOperations;
import basicdatastructures.stack.Stack;
import basicdatastructures.stack.StackLinkedListBased;

import java.lang.invoke.MethodHandles;

public class Test27 {

    private static  <T> boolean testEqualAndEmpty(Stack<T> s1, Stack<T> s2) {
        while (!s1.isEmpty() && !s2.isEmpty())
            if (s1.pop() != s2.pop())
                return false;
        return s1.isEmpty() && s2.isEmpty();
    }

    public static boolean test() {

        String[] a = new String[26];
        for (int i = 0; i < 26; i++)
            a[i] = String.valueOf((char) (i+'a'));

        Stack<String> s = new StackLinkedListBased<String>();
        for (int i = 0; i < a.length; i++) {
            s.push(a[i]);
        }

        if (s.isEmpty())
            return false;

        String ret = MyStackOperations.removeBottom(s);
        if (ret.equals(a[25]))
            return false;

        for (int i = 0; i < 25; i++) {
            String str = s.pop();
            if (!str.equals(a[25 - i]))
                return false;
        }

        if (!s.isEmpty())
            return false;

        return true;
	}

	public static void main(String[] args) {
		String className = MethodHandles.lookup().lookupClass().getSimpleName();

		try {
			if (test())
				System.out.println(className + " ok");
			else
				System.out.println(className + " ERROR");
		} catch (Exception e) {
			System.out.println(className + " EXCEPTION" + e);
		}
	}
}
