package testcases;

import java.lang.invoke.MethodHandles;
import assignment2.MyStackOperations;
import basicdatastructures.stack.Stack;
import basicdatastructures.stack.StackArrayBased;
import basicdatastructures.stack.StackLinkedListBased;

public class Test32 {

    public static boolean test() {
        Stack<Integer> s = new StackLinkedListBased<>();
        for (int i=1; i <= 4; i++) s.push(i); // [1,2,3,4] with 4 top
        int bottom = MyStackOperations.removeBottom(s);
        if (bottom != 1) return false;
        // now stack should be [2,3,4] with 4 top -> pop sequence 4,3,2
        int[] expect = {4,3,2};
        for (int i=0; i < expect.length; i++) if (s.pop() != expect[i]) return false;
        return true;
    }

    public static void main(String[] args) {
        String className = MethodHandles.lookup().lookupClass().getSimpleName();
        try {
            if (test())
                System.out.println(className + " ok");
            else
                System.out.println(className + " ERROR");
        } catch (Exception e) {
            System.out.println(className + " EXCEPTION" + e);
        }
    }
}
