package testcases;

import java.lang.invoke.MethodHandles;
import assignment2.MyStackOperations;
import basicdatastructures.stack.Stack;
import basicdatastructures.stack.StackArrayBased;
import basicdatastructures.stack.StackLinkedListBased;

public class Test34 {

    public static boolean test() {
        Stack<Integer> a = new StackLinkedListBased<>();
        MyStackOperations.reverse(a);
        if (!a.isEmpty()) return false;
        Stack<Integer> b = new StackArrayBased<>();
        b.push(7);
        MyStackOperations.reverse(b);
        if (b.pop() != 7) return false;
        b.push(1);
        b.push(2);
        MyStackOperations.reverse(b);
        if (MyStackOperations.removeBottom(b) != 2) return false;
        if (MyStackOperations.size(b) != 1) return false;
        return true;
    }

    public static void main(String[] args) {
        String className = MethodHandles.lookup().lookupClass().getSimpleName();
        try {
            if (test())
                System.out.println(className + " ok");
            else
                System.out.println(className + " ERROR");
        } catch (Exception e) {
            System.out.println(className + " EXCEPTION" + e);
        }
    }
}
