package testcases;

import assignment2.MyStackOperations;
import basicdatastructures.stack.Stack;
import basicdatastructures.stack.StackArrayBased;
import basicdatastructures.stack.StackLinkedListBased;
import geomerticshapes.Circle;
import geomerticshapes.GeometricShape;
import geomerticshapes.Rectangle;
import geomerticshapes.Square;

import java.lang.invoke.MethodHandles;

public class Test36 {

    private static <T> boolean testEqualAndEmpty(Stack<T> s1, Stack<T> s2) {
        while (!s1.isEmpty() && !s2.isEmpty())
            if (s1.pop() != s2.pop())
                return false;
        return s1.isEmpty() && s2.isEmpty();
    }

    public static boolean test() {
        Stack<GeometricShape> s1 = new StackLinkedListBased<GeometricShape>();
        Stack<GeometricShape> s2 = new StackArrayBased<GeometricShape>();
        if (!MyStackOperations.areEqual(s1, s2))
            return false;

        GeometricShape a[] = {
                new Square(5, 6, 10),
                new Square(1, 2, 10),
                new Circle(10, 20, 1),
                new Rectangle(0, 0, 2, 1),
        };

        for (int i = 0; i < a.length; i++) {
            s1.push(a[i]);
            s2.push(a[i]);
        }

        if (!MyStackOperations.areEqual(s1, s2))
            return false;

        s2.push(new Rectangle(1, 1, 1, 1));
        if (MyStackOperations.areEqual(s1, s2))
            return false;

        return true;
    }


    public static void main(String[] args) {
        String className = MethodHandles.lookup().lookupClass().getSimpleName();

        try {
            if (test())
                System.out.println(className + " ok");
            else
                System.out.println(className + " ERROR");
        } catch (Exception e) {
            System.out.println(className + " EXCEPTION" + e);
        }
    }
}
