package testcases;

import assignment2.MyStackOperations;
import basicdatastructures.stack.Stack;
import basicdatastructures.stack.StackArrayBased;
import basicdatastructures.stack.StackLinkedListBased;
import java.lang.invoke.MethodHandles;

public class Test37 {

    public static boolean test() {
        final int N = 50;
        Integer[] ref = new Integer[N];
        for (int i = 0; i < N; i++) ref[i] = Integer.valueOf(i + 1);

        Stack<Integer> s1 = new StackLinkedListBased<>();
        Stack<Integer> s2 = new StackArrayBased<>();
        for (int i = 0; i < N; i++) { s1.push(ref[i]); s2.push(ref[i]); }

        if (MyStackOperations.size(s1) != N || MyStackOperations.size(s2) != N) return false;
        if (!MyStackOperations.areEqual(s1, s2)) return false;

        MyStackOperations.reverse(s2);
        if (MyStackOperations.areEqual(s1, s2)) return false;
        MyStackOperations.reverse(s2);
        if (!MyStackOperations.areEqual(s1, s2)) return false;

        for (int i = 1; i <= 40; i++) {
            if (MyStackOperations.removeBottom(s1) != i) return false;
            if (MyStackOperations.removeBottom(s2) != i) return false;
        }
        if (MyStackOperations.size(s1) != 10 || MyStackOperations.size(s2) != 10) return false;
        if (!MyStackOperations.areEqual(s1, s2)) return false;

        for (int i = 41; i <= 50; i++) {
            if (MyStackOperations.removeBottom(s1) != i) return false;
            if (MyStackOperations.removeBottom(s2) != i) return false;
        }
        if (!MyStackOperations.areEqual(s1, s2)) return false;

        Stack<Integer> one = new StackArrayBased<>();
        one.push(7);
        if (MyStackOperations.removeBottom(one) != 7 || !one.isEmpty()) return false;

        Stack<Object> empty = new StackLinkedListBased<>();
        try { MyStackOperations.removeBottom(empty); return false; }
        catch (java.util.NoSuchElementException ok) {}

        return true;
    }

    public static void main(String[] args) {
        String className = MethodHandles.lookup().lookupClass().getSimpleName();
        try {
            if (test()) System.out.println(className + " ok");
            else System.out.println(className + " ERROR");
        } catch (Exception e) {
            System.out.println(className + " EXCEPTION" + e);
        }
    }
}
