package testcases;

import java.lang.invoke.MethodHandles;
import assignment2.MyStackOperations;
import basicdatastructures.stack.Stack;
import basicdatastructures.stack.StackArrayBased;
import basicdatastructures.stack.StackLinkedListBased;

public class Test39 {

    public static boolean test() {
        Stack<Integer> s1 = new StackLinkedListBased<>();
        Stack<Integer> s2 = new StackArrayBased<>();
        for (int i = 0; i < 3; i++) s1.push(i); // bottom..top = 0,1,2
        for (int i = 0; i < 2; i++) s2.push(i); // bottom..top = 0,1

        boolean eq = MyStackOperations.areEqual(s1, s2);
        if (eq) return false; // different sizes, must be false

        // Now consume from the BOTTOM instead of popping from the top.
        int[] expect1 = {0, 1, 2};
        for (int v : expect1) {
            if (s1.isEmpty()) return false;
            int got = MyStackOperations.removeBottom(s1);
            if (got != v) return false;
        }

        int[] expect2 = {0, 1};
        for (int v : expect2) {
            if (s2.isEmpty()) return false;
            int got = MyStackOperations.removeBottom(s2);
            if (got != v) return false;
        }

        return s1.isEmpty() && s2.isEmpty();
    }

    public static void main(String[] args) {
        String className = MethodHandles.lookup().lookupClass().getSimpleName();
        try {
            if (test())
                System.out.println(className + " ok");
            else
                System.out.println(className + " ERROR");
        } catch (Exception e) {
            System.out.println(className + " EXCEPTION" + e);
        }
    }
}
