package testcases;

import java.lang.invoke.MethodHandles;
import assignment2.MyStackOperations;
import basicdatastructures.stack.Stack;
import basicdatastructures.stack.StackArrayBased;
import basicdatastructures.stack.StackLinkedListBased;

import geomerticshapes.Square;
import geomerticshapes.GeometricShape;

public class Test40 {

    public static boolean test() {
        Integer[] objs = new Integer[10000];
for (int i = 0; i < 10000; i++) objs[i] = Integer.valueOf(i + 1);

        Stack<Integer> s1 = new StackArrayBased<>();
        Stack<Integer> s2 = new StackArrayBased<>();

        for(int t = 0; t < 10000; ++t) {
            s1.push(objs[t]);
            s2.push(objs[10000 - t - 1]);
        }

        MyStackOperations.reverse(s1);

        if(MyStackOperations.areEqual(s1, s2) == false) return false;
        if(MyStackOperations.areEqual(s1, s2) == false) return false;
        int elem1 = s1.pop();
        int elem2 = MyStackOperations.removeBottom(s2);

        if(elem1 != 1 || elem2 != 10000) return false;

        if(MyStackOperations.size(s1) != MyStackOperations.size(s2)) return false;

        return true;
    }

    public static void main(String[] args) {
        String className = MethodHandles.lookup().lookupClass().getSimpleName();
        try {
            if (test())
                System.out.println(className + " ok");
            else
                System.out.println(className + " ERROR");
        } catch (Exception e) {
            System.out.println(className + " EXCEPTION" + e);
        }
    }
}
