#include <stdio.h>
#include <stdlib.h>
#include <stdbool.h>
#include <string.h>

#include "labexam.h"

// counts the number of c's in string
int count_helper(char* str, char c) {
  char* p = str;
  int count=0;
  while (*p != '\0') {
    if (*p==c)
      count++;
    p++;
  }
  return count;
}

int count_c(char** ar, int n, char c) {
  int i;
  int sum=0;
  for (i=0; i<n; i++)
    sum += count_helper(ar[i], c);
  return sum;
}

// checks if k is in ar
bool contains(const int* ar, int n, int k) {
  int i;
  for(i=0; i<n; i++)
    if (ar[i]==k)
      return true;
  
  // if reached here, k not found
  return false;
}

int count_common(const int* ar1, int n, const int* ar2, int n2) {
  int i;
  int count = 0;
  for (i=0; i<n; i++)
    if (contains(ar2, n2, ar1[i]))
      count++;

  return count;
}


int largest_diff(const LL_t* lst) {
  // handle the case of zero or one node
  if (lst->head==NULL || lst->head->next==NULL)
    return -1;
  
  // size>=2
  int abs_diff;
  int max = -1;
  node_t* prev = lst->head;
  node_t* cur = prev->next;
  while (cur != NULL) {
    abs_diff = abs(cur->data - prev->data);
    if (abs_diff > max)
      max = abs_diff;
   // move to the next pair
    prev = cur;
    cur = cur->next;
  }
  return max;
}
