#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "lib/LL.h"
#include "labexam.h"

void test_q1() { 
  int ans1 = str_find("Hello world", "llo");
  if (ans1 == 2)
    printf("Q1-1 ok\n");
  else
    printf("Q1-1 ERROR\n");

  int ans2 = str_find("ABCDEFG", "BCF");
  if (ans2 == -1)
    printf("Q1-2 ok\n");
  else
    printf("Q1-2 ERROR\n");
}

void test_q2() { 
  int ar[4][3] = {{1, 2, 3},
                  {4, 7,-2},
                  {9,10,12},
                  {1, 5, 4}};
  int* m = sum_row(4,3, ar);
  int m0 = m[0];
  int m1 = m[1];
  int m2 = m[2];
  int m3 = m[3];
  free(m); // checking dynamic memory allocation
  if (m0==6 && m1==9 && m2==31 && m3==10)
    printf("Q2 ok\n");
  else
    printf("Q2 ERROR\n");
}

void test_q3() { 
  LL_t* lst = LLcreate();
  LL_add_to_tail(lst, 1);
  LL_add_to_tail(lst, 3);
  LL_add_to_tail(lst, 8);
  LL_add_to_tail(lst, 4);
  LL_add_to_tail(lst, 3);
  LL_reverse(lst);

  int correct[] = {3,4,8,3,1};
  int i;
  node_t* n = lst->head;
  for(i=0;i<5;i++) {
    if (n==NULL) {
      printf("Q3 ERROR: node %d==NULL unexpected\n", i);
      return;
    }
    if (n->data != correct[i]) {
      printf("Q3 ERROR: node%d->data==%d, expected %d\n", i, n->data, correct[i]);
      return;
    }
    n = n->next;
  }
  if (n==NULL)
    printf("Q3 ok\n");
}

int main(void) {
  test_q1();
  test_q2();
  test_q3();
  return 0;
}
