#include <stdio.h>
#include <stdlib.h>
#include <stdbool.h>
#include <string.h>

#include "labexam.h"

// cheks if str2 is prefix of str1
bool is_prefix(const char* str1, const char* str2) {
  const char* p1 = str1;
  const char* p2 = str2;
  // as long as the chars are equal and not '\0' move forward
  while (*p1==*p2 && *p2!='\0') {
    p1++;
    p2++;
  }
  if (*p2=='\0')
    return true;
  else
    return false;
}

int str_find(const char* str1, const char* str2) {
  int i;
  int n = strlen(str1);
  for(i=0; i<n; i++)
    if (is_prefix(str1+i,str2))
      return i;
  // if reached here, no match was found
  return -1;
}



int compute_sum_row_i(int height, int width, int ar[height][width], int i) {
  int sum=0;
  int j;
  for (j=0;j<width; j++)
    sum += ar[i][j];
  
  return sum;
}

int* sum_row(int height, int width, int ar[height][width]) {
  int* sum = (int*) malloc(height*sizeof(int));
  int i;
  for (i=0; i<height; i++)
    sum[i] = compute_sum_row_i(height, width, ar, i);

  return sum;
  // implement me
  //return NULL;
}


// recursive soluition
// **note that recursion requires O(n) extra space
// LL_reverse can be implemented using iterations with O(1) space
void LL_reverse(LL_t* lst) {
  if (LL_size(lst) >= 2) {
    int tmp = LL_remove_from_head(lst);
    LL_reverse(lst);
    LL_add_to_tail(lst, tmp);
  }
}
