#include <stdio.h>
#include <stdlib.h>
#include <stdbool.h>
#include <string.h>

#include "labexam.h"


void rev_arr(const char** ar, int n) {
  const char* tmp;
  for (int i = 0; i < n/2; i++) {
    tmp = ar[i];
    ar[i] = ar[n-1-i];
    ar[n-1-i] = tmp;
  }
  
}

int move_zeros(int* ar, int n) {
  int next_read = 0;
  int next_write = 0;
  for (next_read = 0; next_read < n; next_read++) {
    if (ar[next_read]!=0) {
      ar[next_write] = ar[next_read];
      next_write++;
    }
  }
  int ret = n-next_write;
  while (next_write<n) {
    ar[next_write]=0;
    next_write++;
  }
  
  return ret;
}

LL_t* LL_copy(LL_t* list) {
  if (!list)
    return NULL;
  LL_t* copy = LL_create();
  node_t* cur = list->head;
  while(cur) {
    LL_add_to_tail(copy, cur->data);
    cur = cur->next;
  }
  return copy;
}
