#include <stdio.h>
#include <stdlib.h>
#include <stdbool.h>
#include <string.h>

#include "labexam.h"

char** get_array_of_asterisks(int n) {
  char** ret = malloc(sizeof(char*)*n);
  for (int i = 0; i < n; i++) {
    ret[i] = malloc(i+1);
    memset(ret[i], '*', i);
    ret[i][i] = '\0';
  }
  
  return ret;
}


long sum_fib_n(int n) {
  if (n<=1)
    return n;

  long* fib = malloc(sizeof(long)*(n+1));
  fib[0] = 0;
  fib[1] = 1;
  long sum = 1;
  for (int i = 2; i<=n; i++) {
    fib[i] = fib[i-1] + fib[i-2];
    sum += fib[i];
  }
  free(fib);
  
  return sum;
}


void queue_filter(queue_t* q, bool(*pred)(int)) {
  queue_t* tmp = queue_create();
  int x;
  // store in tmp only the relevant elements
  while (!queue_is_empty(q)) {
    x = dequeue(q);
    if (pred(x))
      enqueue(tmp, x);
  }

  // move everything from tmp back to q  
  while (!queue_is_empty(tmp)) {
    enqueue(q, dequeue(tmp));
  }

  queue_free(tmp);
}
