#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdbool.h>

#include "labexam.h"

bool compare_LL(LL_t* l1, LL_t* l2) {
  if (l1==l2)
    return true;
  if (!l1 || !l2)
    return false;

  node_t* cur1 = l1->head;
  node_t* cur2 = l2->head;
  while (cur1 && cur2) {
    if (cur1->data!=cur2->data) 
      return false;
    if (cur1->next == NULL && cur2->next == NULL)
      return l1->tail==cur1 && l2->tail==cur2;
    cur1=cur1->next;
    cur2=cur2->next;
  }
  return (cur1==NULL && cur2==NULL);
}


bool is_even(int x) {
  return x%2==0;
}

bool test_q3_14() {
  LL_t* list = LL_create();
  LL_add_to_head(list, 0);
  for(int i=1;i<=3;i++) {
    LL_add_to_head(list, i);
    LL_add_to_tail(list, i);
  }
  // head->3->2->1->0->1->2->3


  int ans = LL_countif(list, is_even);
  /**********test answer**********/ 

  LL_free(list);
  
  if (ans==3) {
    printf("Q3-14 ok\n");
    return true;
  }
  else {
    printf("Q3-14 ERROR\n");
    return false;
  }
}



int main()  {
  test_q3_14();
 
  return 0;
}
