#include <stdio.h>
#include <stdlib.h>
#include <stdbool.h>
#include <string.h>

#include "labexam.h"


int count_digits(char** ar, int n) {
  int count = 0;
  for (int i = 0; i < n; i++) {
    char* p = ar[i];
    while (*p != '\0') {
      if (*p >= '0' && *p <= '9')
        count++;
      p++;
    }
  }
  return count;
}


void map_k_times(int* ar, int n, int(*f)(int)) {
  for (int k = 0; k < n; k++)
    for (int j = 0; j < k; j++)
      ar[k] = f(ar[k]);
}


float average_diff(const LL_t* lst) {
  if (lst==NULL || lst->head==NULL || lst->head->next==NULL)
    return -1; 
  
  int diff;
  int count = 0;
  float sum = 0;
  node_t* prev;
  node_t* cur = lst->head; 
  while (cur->next != NULL) { 
    prev = cur;
    cur = cur->next;
    diff = abs(prev->data - cur->data);
    sum += diff;
    count++;
  }

  return sum/count;
}
