#include <stdio.h>
#include <stdlib.h>
#include <stdbool.h>
#include <string.h>

#include "labexam.h"


char* str_make_copy(const char* str) {
  char* ret = malloc(strlen(str)+1);
  if (!ret)
    return NULL;
    
  strcpy(ret, str);
  return ret;
}



int* f_compositions(int a, int(*f)(int), int n) {
  int* ret = (int*) malloc(n*sizeof(int));
  ret[0] = a;
  for (int i = 1; i < n; i++)
    ret[i] = f(ret[i-1]);
  
  return ret;
}


int LL_remove_last(LL_t* lst) {
  if (lst->head == lst->tail) // size==1
    return LL_remove_from_head(lst);
  
  node_t* prev = lst->head;
  node_t* cur = prev->next;
  while (cur->next) {
    prev = cur;
    cur = cur->next;
  }

  int ret = cur->data;
  LLnode_free(cur);
  lst->tail = prev;
  prev->next = NULL;
  
  return ret;
}
