#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdbool.h>

#include "labexam.h"

bool compare_LL(LL_t* l1, LL_t* l2) {
  if (l1==l2)
    return true;
  if (!l1 || !l2)
    return false;

  node_t* cur1 = l1->head;
  node_t* cur2 = l2->head;
  while (cur1 && cur2) {
    if (cur1->data!=cur2->data) 
      return false;
    if (cur1->next == NULL && cur2->next == NULL)
      return l1->tail==cur1 && l2->tail==cur2;
    cur1=cur1->next;
    cur2=cur2->next;
  }
  return (cur1==NULL && cur2==NULL);
}


bool is_odd(int x) {
  return x%2==1;
}

bool test_q3_14() {
  LL_t* list = LL_create();
  for(int i=0;i<=7;i++) {
    LL_add_to_tail(list, i);
  }
  // head->0->1->2->3->4->5->6->7


  int ans = LL_sum_cond(list, is_odd);
  // expected sum is 1+3+5+7
  /**********test answer**********/ 

  LL_free(list);
  
  if (ans==16) {
    printf("Q3-14 ok\n");
    return true;
  }
  else {
    printf("Q3-14 ERROR\n");
    return false;
  }
}



int main()  {
  test_q3_14();
 
  return 0;
}
