#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdbool.h>

#include "labexam.h"

bool compare_LL(LL_t* l1, LL_t* l2) {
  if (l1==l2)
    return true;
  if (!l1 || !l2)
    return false;

  node_t* cur1 = l1->head;
  node_t* cur2 = l2->head;
  while (cur1 && cur2) {
    if (cur1->data!=cur2->data) 
      return false;
    if (cur1->next == NULL && cur2->next == NULL)
      return l1->tail==cur1 && l2->tail==cur2;
    cur1=cur1->next;
    cur2=cur2->next;
  }
  return (cur1==NULL && cur2==NULL);
}

bool non_zero(int x) {
  return x != 0;
}

#define LEN 20000
bool test_q3_20() {
  int sum = 0;
  srand(123);
  LL_t* list = LL_create();
  LL_t* expected_lst = LL_create();
  for(int i=0;i<=LEN;i++) {
    int v = rand() % 1000 - 500;
    LL_add_to_tail(list, v);
    LL_add_to_tail(expected_lst, v);
    sum += v;
  }

  int ans = LL_sum_cond(list, non_zero);

  bool are_eq = compare_LL(list, expected_lst);
  
  LL_free(list);
  LL_free(expected_lst);

  /**********test answer**********/ 
  if (ans == sum && are_eq) {
    printf("Q3-20 ok\n");
    return true;
  }
  else {
    printf("Q3-20 ERROR\n");
    return false;
  }
}



int main()  {
  test_q3_20();
 
  return 0;
}
