#include <stdio.h>
#include <stdlib.h>
#include <stdbool.h>
#include <string.h>

#include "labexam.h"


void reverse_subarray(char** ar, int start, int end) {
  for (int i=start; i <= (start+end)/2; i++) {
    void* tmp = ar[i];
    ar[i] = ar[end-(i-start)];
    ar[end-(i-start)] = tmp;
  }
}


bool is_prefix(const char* str, const char* pattern) {
  const char* p1 = str;
  const char* p2 = pattern;
  // as long as the chars are equal and not '\0' move forward
  while (*p1==*p2 && *p2!='\0') {
    p1++;
    p2++;
  }
  if (*p2=='\0')
    return true;
  else
    return false;
}
  
int str_find_last(const char* str, const char* pattern) {
  int i;
  int str_len = strlen(str);
  int pattern_len = strlen(pattern);
  for(i=str_len-pattern_len; i>=0; i--)
    if (is_prefix(str+i,pattern))
      return i;

  // if reached here, no match was found
  return -1; 
}


int LL_countif(LL_t* lst, bool (*pred)(int)) {
  int count = 0;
  node_t* cur = lst->head;
  while (cur) {
    if (pred(cur->data))
      count++;
    cur = cur->next;
  }
  
  return count;
}
