#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "labexam.h"

void test_q1() {
  char* str = "Hello";
  char* ans = str_make_copy(str);

  if (!ans || ans==str) {
    printf("Q1 ERROR\n");
    return;
  }

  bool okFlag = (strcmp(str,ans)==0);
  free(ans);
  if (okFlag) 
    printf("Q1 ok\n");
  else
    printf("Q1 ERROR\n");

}


int plus1(int x) {
  return x+1;
}

void test_q2() { 
  int* ans = f_compositions(0, plus1, 5);

  if (!ans) {
    printf("Q2 ERROR\n");
    return;
  }

  int correct[] = {0,1,2,3,4};
  bool okFlag = true;
  for(int i=0;i<5;i++)
    if (ans[i]!=correct[i])
      okFlag = false;

  free(ans);

  if (okFlag)
    printf("Q2 ok\n");
  else
    printf("Q2 ERROR\n");

}


void test_q3() { 
  LL_t* list = LL_create();
  for(int i=4;i<=7;i++) {
    LL_add_to_tail(list, i);
  }

  int ans = LL_remove_last(list);

  /**********test answer**********/ 
  if (ans != 7) {
    printf("Q3 ERROR\n");
    return;
  }

  // check that list is now 4->5->6
  bool okFlag = true;
  node_t* cur = list->head;
  for (int i = 4; i <= 6; i++) {
    okFlag &= cur && cur->data == i;
    cur = cur->next;
  }
  okFlag &= cur==NULL;

  LL_free(list);
  if (okFlag)
    printf("Q3 ok\n");
  else
    printf("Q3 ERROR\n");
}


int main(void) {
  test_q1();
  test_q2();
  test_q3();
  return 0;
}
