#include <stdio.h>
#include <stdlib.h>
#include <stdbool.h>
#include <string.h>

#include "labexam.h"



bool is_reverse(const char* str1, const char* str2) {
  int len1 = strlen(str1);
  int len2 = strlen(str2);
  
  if (len1 != len2)
    return false;
  
  for (int i=0; i < len1; i++)
    if (str1[i] != str2[len1-1-i])
      return false;

  return true; // if reached here, returned true
  
}


LL_t* array_to_LL(int* ar, int n) {
  LL_t* list = LL_create();
  for (int i=0; i<n; i++)
    LL_add_to_tail(list, ar[i]);

  return list;
}


int stack_forget(stack_t* s, int k) {
  int ret=0;
  stack_t* tmp = stack_create();
  // move from s1 to tmp1 in reverse order
  while (!stack_is_empty(s)) {
    stack_push(tmp, stack_pop(s));
    ret++;
  }

  if (ret>k)
    ret=k;

  // throw away the last ret elements
  for (int i=0; i<ret; i++)
    stack_pop(tmp);
  // return the rest to s
    while (!stack_is_empty(tmp))
    stack_push(s, stack_pop(tmp));

  stack_free(tmp);
  return ret;
    
}



