#include <stdio.h>
#include <stdlib.h>
#include <stdbool.h>
#include <string.h>

#include "labexam.h"


char* concat_all(const char* arr[], int n) {
  int total_len=0;
  for (int i=0; i<n; i++)
    total_len += strlen(arr[i]);

  char* ret = (char*)malloc(total_len+1); // same as (total_len+1)*sizeof(char)
  // remember +1 for the string terminator

  ret[0] = '\0';  
  for (int i=0; i<n; i++)
    strcat(ret, arr[i]);

  return ret;
}
 

bool is_palindrome(unsigned int n) {
  unsigned int m;

  int count_digits = 0;
  for (m=n; m>0; m=m/10)
    count_digits++;

  int* tmp = (int*)malloc(count_digits*sizeof(int));
  m = n;
  for (int i = count_digits-1; i>=0; i--) {
    tmp[i] = m%10;
    m = m/10;
  }

  bool flag = true;
  for (int i = 0; i<=count_digits/2; i++) {
    if (tmp[i] != tmp[count_digits-1-i])
      flag=false;
  }

  free(tmp);
  return flag;
}
    
int LL_remove_last_k(LL_t* list, unsigned int k) {
  if (!list || k==0)
    return 0;

  // compute the length of the list
  node_t* cur;
	int len = 0;
  for (cur = list->head; cur; cur=cur->next)
		len++;

  LL_t* tmp_list = LL_create();
  // move the first n-k nodes to tmp_list
	for(int i = 0;i<len-k;i++)
    LL_add_to_head(tmp_list,LL_remove_from_head(list));

  // remove the last k nodes from the list
  int sum = 0;
	for(int i = 0;i<k;i++)
    sum += LL_remove_from_head(list);

  // move the nodes from tmp_list back to list
	for(int i = 0;i<len-k;i++)
    LL_add_to_head(list, LL_remove_from_head(tmp_list));

  free(tmp_list);

	return sum;
}
