#include <stdio.h>
#include <stdlib.h>
#include <stdbool.h>
#include <string.h>

#include "labexam.h"

int str_vowels2asterisks(char* str) {
  int count = 0;
  while (*str) {
    char c = *str;
    if (c=='a' || c=='e' || c=='i' || c=='o' || c=='u' ) {
      *str = '*';
      count++;
    }
    str++;
  }
  return count;
}

int vowels2asterisks(char* ar[], int n) {
  int count = 0;
  for(int i=0;i<n;i++)
    count += str_vowels2asterisks(ar[i]);

  return count;
}


int longest_equal_seq(const int* ar, int n) {
  int max = 1;
  int current_streak = 1;
  for(int i=1;i<n;i++) {
    if (ar[i]==ar[i-1]) {
      current_streak++;
      if (current_streak>max)
        max = current_streak;
    }
    else
      current_streak=1;
  }
  return max;
}


void queues_swap(queue_t* q1, queue_t* q2) {

  if(q1==q2)
    return;

  queue_t* tmp = queue_create();

  // move from q1 to tmp
  while (!queue_is_empty(q1))
    enqueue(tmp, dequeue(q1));

  // move from q2 to q1
  while (!queue_is_empty(q2))
    enqueue(q1, dequeue(q2));

  // move from tmp to q2
  while (!queue_is_empty(tmp))
    enqueue(q2, dequeue(tmp));

  queue_free(tmp);
  return;
}  
