#include <stdio.h>
#include <stdlib.h>
#include <stdbool.h>
#include <string.h>

#include "labexam.h"


void str_right_rotate(char* str) {
  int n = strlen(str);
  char tmp = str[n-1];
  for (int i=n-1;i>0;i--)
    str[i] = str[i-1];
  str[0] = tmp;
}


int* map_to_new_array(const int* ar, int n, int(*foo)(int)) {
  int* ret = malloc(n*sizeof(int));
  for (int i=0;i<n;i++)
    ret[i] = foo(ar[i]);
  return ret;
}


void stacks_swap(stack_t* s1, stack_t* s2) {
  if(s1==s2)
    return;

  stack_t* tmp1 = stack_create();
  // move from s1 to tmp1 in reverse order
  while (!stack_is_empty(s1))
    stack_push(tmp1, stack_pop(s1));

  stack_t* tmp2 = stack_create();
  // move from s2 to tmp2 in reverse order
  while (!stack_is_empty(s2))
    stack_push(tmp2, stack_pop(s2));

  // move from tmp1 to s2 reversing the order again to become correct
  while (!stack_is_empty(tmp1))
    stack_push(s2, stack_pop(tmp1));

  // move from tmp2 to s1 reversing the order again to become correct
  while (!stack_is_empty(tmp2))
    stack_push(s1, stack_pop(tmp2));

  free(tmp1);
  free(tmp2);
}
