#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "labexam.h"

void test_q1() { 
  char str[] = {'A','b','C','d','E','f','\0'};
  str_right_rotate(str);

  /**********test answer**********/ 
  char* correct_ans = "fAbCdE";
  if (strcmp(str, correct_ans)==0)
    printf("Q1 ok\n");
  else
    printf("Q1 ERROR\n");
}


int square(int x) { return x*x;}

void test_q2() { 
  int ar[] = {2,6,2,3,1,-10,0};
  int* ans = map_to_new_array(ar, 7,square);

  /**********test answer**********/ 
  if (ans==NULL) {
    printf("Q2 ERROR : ans==NULL\n");
    return;
  }

  int correct[] = {4,36,4,9,1,100,0};
  bool okFlag = true;
  for(int i=0;i<7;i++) {
    if (ans[i]!=correct[i])
      okFlag = false;
  }
  free(ans);

  if (okFlag)
    printf("Q2 ok\n");
  else
    printf("Q2 ERROR : incorrect values\n");

}

bool is_even(int x) {return x%2 == 0;}

void test_q3() { 
  stack_t* s1 = stack_create();
  stack_push(s1,10);
  stack_push(s1,20);
  stack_push(s1,30);
  stack_t* s2 = stack_create();
  stack_push(s2,400);
  stack_push(s2,500);
  stacks_swap(s1,s2);

  stack_t* s1correct = stack_create();
  stack_push(s1correct,400);
  stack_push(s1correct,500);

  stack_t* s2correct = stack_create();
  stack_push(s2correct,10);
  stack_push(s2correct,20);
  stack_push(s2correct,30);

  /**********test answer**********/ 
  bool ans1 = LL_equal(s1->list, s1correct->list);
  bool ans2 = LL_equal(s2->list, s2correct->list);

  stack_free(s1);
  stack_free(s2);
  stack_free(s1correct);
  stack_free(s2correct);
  
  if (!ans1) {
    printf("Q3 ERROR : s1 is incorrect, expected [400,500]\n");
    return;
  }
  if (!ans2) {
    printf("Q3 ERROR : s2 is incorrect, expected [10,20,30]\n");
    return;
  }
  else printf("Q3 ok\n"); }

int main(void) {
  test_q1();
  test_q2();
  test_q3();
  return 0;
}
