#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "lib/LL.h"
#include "labexam.h"

void test_q1() { 
  char str0[] = "hello";
  char str1[] = "AEIOUaeiou";
  char str2[] = "oNe-TwO-ThReE";
  char* ar[3] = {str0, str1, str2};

  /**********test answer**********/ 
  if (vowels2asterisks(ar, 3)==10   // answer = 2+5+3
      && strcmp(str0, "h*ll*")==0
      && strcmp(str1, "AEIOU*****")==0
      && strcmp(str2, "*N*-TwO-ThR*E")==0)
    printf("Q1 ok\n");
  else
    printf("Q1 ERROR\n");
}

void test_q2() { 
  int ar1[] = {2,6,6,6,6,1,1};
  int ans1 = longest_equal_seq(ar1,7);

  /**********test answer**********/ 
  if (ans1==4)
    printf("Q2-1 ok\n");
  else
    printf("Q2-1 ERROR : expected 4, return = %d\n", ans1);

  int ar2[] = {1,2,4,4,4,7,1,1,8,1,9,1,1,100,0};
  int ans2 = longest_equal_seq(ar2,15);

  /**********test answer**********/ 
  if (ans2==3)
    printf("Q2-2 ok\n");
  else
    printf("Q2-2 ERROR : expected 3, return = %d\n", ans2);

}

void test_q3() { 
  queue_t* q1 = queue_create();
  enqueue(q1,10);
  enqueue(q1,20);
  enqueue(q1,30);
  queue_t* q2 = queue_create();
  enqueue(q2,400);
  enqueue(q2,500);
  queues_swap(q1,q2);

  queue_t* q1correct = queue_create();
  enqueue(q1correct,400);
  enqueue(q1correct,500);

  queue_t* q2correct = queue_create();
  enqueue(q2correct,10);
  enqueue(q2correct,20);
  enqueue(q2correct,30);

  /**********test answer**********/ 
  bool check1 = LL_equal(q1->list, q1correct->list);
  if (!check1) {
    printf("Q3 ERROR : q1 is incorrect, expected [400,500]\n");
    return;
  }
  bool check2 = LL_equal(q2->list, q2correct->list);
  if (!check2) {
    printf("Q3 ERROR : q2 is incorrect, expected [10,20, 30]\n");
    return;
  }
  
  queue_free(q1correct);
  queue_free(q2correct);
  queue_free(q1);
  queue_free(q2);
  printf("Q3 ok\n");

}

int main(void) {
  test_q1();
  test_q2();
  test_q3();
  return 0;
}
