#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "lib/LL.h"
#include "labexam.h"

// large stack
#define LEN 100
#define SEED 98
void test_q3_5() { 
  stack_t* s = stack_create();
  srand(SEED);
  for (int i=0; i<LEN; i++)
    stack_push(s, rand());

  stack_t* ans = stack_copy(s);

  /**********test answer**********/ 
  stack_t* s_my_copy = stack_create();
  srand(SEED);
  for (int i=0; i<LEN; i++)
    stack_push(s_my_copy, rand());

  bool is_correct = (ans && ans!=s && ans->list!=s->list
        && LL_equal(ans->list, s_my_copy->list)
        && LL_equal(s->list, s_my_copy->list));
  stack_free(s);
  stack_free(s_my_copy);
  stack_free(ans);

  if (is_correct)
    printf("Q3-18 ok\n");
  else
    printf("Q3-18 ERROR\n");
}

int main(void) {
  test_q3_5();
  return 0;
}
