#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "labexam.h"

void test_q1() { 
  char* str = "h1e2l34lo78";

  /**********test answer**********/ 
  if (sum_of_digits(str) == 25) // 1+2+3+4+7+8
    printf("Q1 ok\n");
  else
    printf("Q1 ERROR\n");
}

void test_q2() { 
  int ar[] = {2,6,2,3};
  int* ans = duplicate_values(ar, 4);

  /**********test answer**********/ 
  if (ans==NULL) {
    printf("Q2 ERROR : ans==NULL\n");
    return;
  }

  int correct[] = {2,2,6,6,2,2,3,3};
  bool okFlag = true;
  for(int i=0;i<8;i++) {
    if (ans[i]!=correct[i])
      okFlag = false;
  }

  free(ans);

  if (okFlag)
    printf("Q2 ok\n");
  else
    printf("Q2 ERROR : incorrect values\n");

}

bool is_even(int x) {return x%2 == 0;}

void test_q3() { 
  LL_t* list = LL_create();
  for (int i=0;i<20;i++)
    LL_add_to_tail(list,i);

  LL_filter(list, is_even);

  /**********test answer**********/ 
  LL_t* correct_ans = LL_create();
  for (int i=0;i<20;i+=2)
    LL_add_to_tail(correct_ans,i);

  bool okFlag=LL_equal(list, correct_ans);
  LL_free(list);
  LL_free(correct_ans);

  if (okFlag)
    printf("Q3 ok\n");
  else
    printf("Q3 ERROR\n");
}

int main(void) {
  test_q1();
  test_q2();
  test_q3();
  return 0;
}
