#include <stdio.h>
#include <stdlib.h>
#include <stdbool.h>
#include <string.h>

#include "labexam.h"



void sort_digits(int* ar, int n) {
  int i;
  int count_digits[10];
  for (int d=0;d<10;d++)
    count_digits[d]=0;
  for (i=0;i<n;i++)
    count_digits[ar[i]]++;
  
  // populate the values
  i=0;
  for (int d=0;d<10;d++) {
    for (int j=0;j<count_digits[d];j++) 
      ar[i++] = d;
  }
}


int* max_arrays(int* a, int* b, int n) {
  int* ret = malloc(n*sizeof(int));
  for (int i=0;i<n;i++)
    if (a[i]>b[i])
      ret[i] = a[i];
    else
      ret[i] = b[i];

  return ret;
}






int queue_countif(queue_t* q, bool (*pred)(int)) {
  int count=0;
  queue_t* tmp = queue_create();

  // move the elements from q to tmp and count
  while(!queue_is_empty(q)) {
    int x = dequeue(q);
    enqueue(tmp,x);
    if (pred(x))
      count++;
  }
  // return back from tmp to q
  while(!queue_is_empty(tmp)) {
    enqueue(q,dequeue(tmp));
  }
  
  free(tmp);
  return count;
}

