#include <stdio.h>
#include <stdlib.h>
#include <stdbool.h>
#include <string.h>

#include "labexam.h"


int count_chars(const char* str, char c) {
  int count = 0;
  while(*str) {
    if (*str==c)
      count++;
    str++;
  }
  return count;
}

// the functon gets a string and returns
// the most frequent char in the string
// if str is the empty string, the funnction return '\0' 
char most_frequent_char(const char* str) {
  int len = strlen(str);
  int max=0;
  char most_frequent = '\0';
  int current_count;
  for (int i = 0; i<len; i++) {
    current_count = count_chars(str, str[i]);
    if (current_count > max) {
      max = current_count;
      most_frequent = str[i];
    }
  }
  return most_frequent;
}
 

// the functon gets an array of length n and a function foo
// it counts the number if indices i such that foo(i)==i
int count_foo(int* ar, int n, int(*foo)(int)) {
  int count = 0;
  for (int i=0;i<n;i++) {
    if (foo(i)==ar[i])
      count++;
  }
  return count;
}
  

int LL_delete_node(LL_t* list, node_t* node) {
  if (node==list->head) {
    LL_remove_from_head(list);
    return 1;
  }
  else {
    node_t* cur = list->head;
    while (cur && cur->next!=node) {
      cur = cur->next;
    }
    if (cur==NULL) // node not found
      return 0;
    else { // cur->next==node
      cur->next = node->next;
      LLnode_free(node);
      return 1;
    }
  }

  return 0;
}
