#include <stdio.h>
#include <stdlib.h>

#include "stack.h"

stack_t* stack_create() {
  stack_t* s = (stack_t*) malloc(sizeof(stack_t));
  s->list = LL_create();
  return s;
}

void stack_push(stack_t* s, int item) {
  LL_add_to_head(s->list, item);
}

int stack_pop(stack_t* s) {
  return LL_remove_from_head(s->list);
}

int stack_is_empty(stack_t* s) {
    return (s->list->head==NULL);
}


void stack_free(stack_t* s) {
  LL_free(s->list);
  free(s);
}
