#include <stdio.h>
#include <stdlib.h>
#include <stdbool.h>
#include <string.h>

#include "labexam.h"

int count_hyphens_substrings(const char* str) {
  int count = 0;
  int i=0;
  bool prev_is_hyphen = false;
  while (str[i]) {
    if (str[i]=='-') {
      if (prev_is_hyphen==false) {
      count++;
      prev_is_hyphen=true;
      }
    }
    else {
      prev_is_hyphen=false;
    }
    i++;
  }
  return count;
}


int countif(LL_t* list, bool(*pred)(int)) {
  if (list==NULL)
    return 0;
  int count = 0;
  node_t* cur = list->head;
  while (cur) {
    if (pred(cur->data))
      count++;
    cur = cur->next;
  }
  return count;
}


stack_t* stack_copy(stack_t* orig) {
  stack_t* tmp = stack_create();
  stack_t* ret = stack_create();
  while (!stack_is_empty(orig)) {
    stack_push(tmp, stack_pop(orig));
  }
  // now all values are in orig in reverse order

  int x;
  while (!stack_is_empty(tmp)) {
    x = stack_pop(tmp);
    stack_push(orig, x);
    stack_push(ret, x);
  }

  stack_free(tmp);
  return ret;
}

