#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "lib/LL.h"
#include "labexam.h"

void test_q1() { 
  const char* str1 = "--aabc-----hi***";
  const char* str2 = "a!ba-ei-XXoi---";
  const char* str3 = "!&bcdEEEO*";

  /**********test answer**********/ 
  if (count_hyphens_substrings(str1)==2)
    printf("Q1-1 ok\n");
  else
    printf("Q1-1 ERROR\n");

  if (count_hyphens_substrings(str2)==3)
    printf("Q1-2 ok\n");
  else
    printf("Q1-2 ERROR\n");
  if (count_hyphens_substrings(str3)==0)
    printf("Q1-3 ok\n");
  else
    printf("Q1-3 ERROR\n");

}

// used for testing countif
bool is_positive(int x) { return x>0;}

void test_q2() { 
  LL_t* list = LL_create();
  for (int i=-3;i<=3;i++)
    LL_add_to_head(list, i);
  int ans1 = countif(list, is_positive);

  /**********test answer**********/ 
  if (ans1==3)
    printf("Q2-1 ok\n");
  else
    printf("Q2-1 ERROR : expected 3, return = %d\n", ans1);

  for (int i=-5;i<=5;i++)
    LL_add_to_tail(list, i);
  int ans2 = countif(list, is_positive);
  LL_free(list);

  /**********test answer**********/ 
  if (ans2==8)
    printf("Q2-2 ok\n");
  else
    printf("Q2-2 ERROR : expected 8, return = %d\n", ans2);
}

void test_q3() { 
  stack_t* s = stack_create();
  stack_push(s, 10);
  stack_push(s, 20);
  stack_push(s, 30);
  stack_push(s, 30);
  stack_push(s, 30);

  stack_t* ans = stack_copy(s);

// check for correctness
  stack_t* s_my_copy = stack_create();
  stack_push(s_my_copy, 10);
  stack_push(s_my_copy, 20);
  stack_push(s_my_copy, 30);
  stack_push(s_my_copy, 30);
  stack_push(s_my_copy, 30);

  /**********test answer**********/ 
  if (ans==s) {
    printf("Q3 ERROR : you just copied the pointer. Need to do deep copy\n");
    return;
  }
  if (!ans) {
    printf("Q3 ERROR : returned NULL\n");
    return;
  }

  bool list_not_modified=LL_equal(s->list, s_my_copy->list);
  if (!list_not_modified) {
    printf("Q3 ERROR : input modified\n");
    return;
  }

  bool check_copy = LL_equal(ans->list, s_my_copy->list);
  if (!check_copy) {
    printf("Q3 ERROR");
    return;
  }
  stack_free(s);
  stack_free(s_my_copy);
  stack_free(ans);
  printf("Q3 ok\n");

}

int main(void) {
  test_q1();
  test_q2();
  test_q3();
  return 0;
}
