#ifndef LAB_EXAM_205_206_H
#define LAB_EXAM_205_206_H

#include <stdbool.h>

#include "lib/LL.h"
#include "lib/stack.h"
#include "lib/queue.h"


// the function gets a string and computes the sum of all digits in the string
// all non-digit chars are ignored
// you may assume the sum fits into an int
int sum_of_digits(const char* str);


// the function gets an array of ints of length n
// and returns a new array (on the heap)
// where each value of the input is duplicated
// for example, if the input is [1,2,7,1]
// then the output should be [1,1,2,2,7,7,1,1]
int* duplicate_values(const int* ar, int n);


// gets a linked list of ints and a predicate
// and keeps in the list only the nodes satisfying pred(node->data)==true
// all nodes not satisfying pred are removed from the list
// returns the number of removed elements
int LL_filter(LL_t* list, bool (*pred)(int));


#endif
